/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.RootPaneContainer;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.application.ApplicationAction;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class B
extends Task.InputBlocker {
    private static final Logger F = Logger.getLogger(B.class.getName());
    private JDialog G = null;

    B(Task task, Task.BlockingScope blockingScope, Object object, ApplicationAction applicationAction) {
        super(task, blockingScope, object, applicationAction);
    }

    private void D(boolean bl) {
        Action action = (Action)this.getTarget();
        action.setEnabled(!bl);
    }

    private void C(boolean bl) {
        Component component = (Component)this.getTarget();
        component.setEnabled(!bl);
    }

    private void A(Component component, List<Component> list) {
        String string = component.getName();
        if (string != null && string.startsWith("BlockingDialog")) {
            list.add(component);
        }
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                this.A(component2, list);
            }
        }
    }

    private List<Component> A(Component component) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        this.A(component, arrayList);
        return arrayList;
    }

    private void B(Component component) {
        ApplicationAction applicationAction;
        ResourceMap resourceMap = this.getTask().getResourceMap();
        if (resourceMap != null) {
            resourceMap.injectComponents(component);
        }
        if ((applicationAction = this.getAction()) != null) {
            ResourceMap resourceMap2 = applicationAction.getResourceMap();
            String string = applicationAction.getName();
            for (Component component2 : this.A(component)) {
                component2.setName(string + "." + component2.getName());
            }
            resourceMap2.injectComponents(component);
        }
    }

    private JDialog A() {
        Object object;
        Component component;
        JOptionPane jOptionPane = new JOptionPane();
        if (this.getTask().getUserCanCancel()) {
            component = new JButton();
            component.setName("BlockingDialog.cancelButton");
            object = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    B.this.getTask().cancel(true);
                }
            };
            ((AbstractButton)component).addActionListener((ActionListener)object);
            jOptionPane.setOptions(new Object[]{component});
        } else {
            jOptionPane.setOptions(new Object[0]);
        }
        component = (Component)this.getTarget();
        object = this.getTask().getTitle();
        Object object2 = object == null ? "BlockingDialog" : object;
        final JDialog jDialog = jOptionPane.createDialog(component, (String)object2);
        jDialog.setModal(true);
        jDialog.setName("BlockingDialog");
        jDialog.setDefaultCloseOperation(0);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (B.this.getTask().getUserCanCancel()) {
                    B.this.getTask().cancel(true);
                    jDialog.setVisible(false);
                }
            }
        };
        jDialog.addWindowListener(windowAdapter);
        jOptionPane.setName("BlockingDialog.optionPane");
        this.B(jDialog);
        this.A(jOptionPane);
        jDialog.pack();
        return jDialog;
    }

    private void A(JOptionPane jOptionPane) {
        Object object = jOptionPane.getMessage();
        if (object instanceof String) {
            Font font = jOptionPane.getFont();
            final JTextArea jTextArea = new JTextArea((String)object);
            jTextArea.setFont(font);
            int n = jTextArea.getFontMetrics(font).getHeight();
            Insets insets = new Insets(0, 0, n, 24);
            jTextArea.setMargin(insets);
            jTextArea.setEditable(false);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setBackground(jOptionPane.getBackground());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jTextArea, "Center");
            final JProgressBar jProgressBar = new JProgressBar();
            jProgressBar.setName("BlockingDialog.progressBar");
            jProgressBar.setIndeterminate(true);
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                        jProgressBar.setIndeterminate(false);
                        jProgressBar.setValue((Integer)propertyChangeEvent.getNewValue());
                        B.this.A(jProgressBar);
                    } else if ("message".equals(propertyChangeEvent.getPropertyName())) {
                        jTextArea.setText((String)propertyChangeEvent.getNewValue());
                    }
                }
            };
            this.getTask().addPropertyChangeListener(propertyChangeListener);
            jPanel.add((Component)jProgressBar, "South");
            this.B(jPanel);
            jOptionPane.setMessage(jPanel);
        }
    }

    private void A(JProgressBar jProgressBar) {
        if (!jProgressBar.isStringPainted()) {
            return;
        }
        String string = "progressBarStringFormat";
        if (jProgressBar.getClientProperty(string) == null) {
            jProgressBar.putClientProperty(string, jProgressBar.getString());
        }
        String string2 = (String)jProgressBar.getClientProperty(string);
        if (jProgressBar.getValue() <= 0) {
            jProgressBar.setString("");
        } else if (string2 == null) {
            jProgressBar.setString(null);
        } else {
            double d2 = (double)jProgressBar.getValue() / 100.0;
            long l = this.getTask().getExecutionDuration(TimeUnit.SECONDS);
            long l2 = l / 60L;
            long l3 = (long)(0.5 + (double)l / d2) - l;
            long l4 = l3 / 60L;
            String string3 = String.format(string2, l2, l - l2 * 60L, l4, l3 - l4 * 60L);
            jProgressBar.setString(string3);
        }
    }

    private void B(boolean bl) {
        RootPaneContainer rootPaneContainer = null;
        for (Component component = (Component)this.getTarget(); component != null; component = component.getParent()) {
            if (!(component instanceof RootPaneContainer)) continue;
            rootPaneContainer = (RootPaneContainer)((Object)component);
            break;
        }
        if (rootPaneContainer != null) {
            if (bl) {
                JMenuBar jMenuBar = rootPaneContainer.getRootPane().getJMenuBar();
                if (jMenuBar != null) {
                    jMenuBar.putClientProperty(this, jMenuBar.isEnabled());
                    jMenuBar.setEnabled(false);
                }
                _A _A2 = new _A();
                InputVerifier inputVerifier = new InputVerifier(){

                    public boolean verify(JComponent jComponent) {
                        return !jComponent.isVisible();
                    }
                };
                _A2.setInputVerifier(inputVerifier);
                Component component = rootPaneContainer.getGlassPane();
                rootPaneContainer.getRootPane().putClientProperty(this, component);
                rootPaneContainer.setGlassPane(_A2);
                _A2.setVisible(true);
                _A2.revalidate();
            } else {
                JMenuBar jMenuBar = rootPaneContainer.getRootPane().getJMenuBar();
                if (jMenuBar != null) {
                    boolean bl2 = (Boolean)jMenuBar.getClientProperty(this);
                    jMenuBar.putClientProperty(this, null);
                    jMenuBar.setEnabled(bl2);
                }
                Component component = (Component)rootPaneContainer.getRootPane().getClientProperty(this);
                rootPaneContainer.getRootPane().putClientProperty(this, null);
                if (!component.isVisible()) {
                    rootPaneContainer.getGlassPane().setVisible(false);
                }
                rootPaneContainer.setGlassPane(component);
            }
        }
    }

    private int B() {
        ResourceMap resourceMap;
        Integer n = null;
        String string = "BlockingDialogTimer.delay";
        ApplicationAction applicationAction = this.getAction();
        if (applicationAction != null) {
            resourceMap = applicationAction.getResourceMap();
            String string2 = applicationAction.getName();
            n = resourceMap.getInteger(string2 + "." + string);
        }
        resourceMap = this.getTask().getResourceMap();
        if (n == null && resourceMap != null) {
            n = resourceMap.getInteger(string);
        }
        return n == null ? 0 : n;
    }

    private void A(boolean bl) {
        if (bl) {
            Object object;
            if (this.G != null) {
                object = String.format("unexpected InputBlocker state [%s] %s", bl, this);
                F.warning((String)object);
                this.G.dispose();
            }
            this.G = this.A();
            object = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (B.this.G != null) {
                        B.this.G.setVisible(true);
                    }
                }
            };
            Timer timer = new Timer(this.B(), (ActionListener)object);
            timer.setRepeats(false);
            timer.start();
        } else if (this.G != null) {
            this.G.dispose();
            this.G = null;
        } else {
            String string = String.format("unexpected InputBlocker state [%s] %s", bl, this);
            F.warning(string);
        }
    }

    @Override
    protected void block() {
        switch (this.getScope()) {
            case ACTION: {
                this.D(true);
                break;
            }
            case COMPONENT: {
                this.C(true);
                break;
            }
            case WINDOW: 
            case APPLICATION: {
                this.B(true);
                this.A(true);
            }
        }
    }

    @Override
    protected void unblock() {
        switch (this.getScope()) {
            case ACTION: {
                this.D(false);
                break;
            }
            case COMPONENT: {
                this.C(false);
                break;
            }
            case WINDOW: 
            case APPLICATION: {
                this.B(false);
                this.A(false);
            }
        }
    }

    private static class _A
    extends JPanel {
        _A() {
            super(null, false);
            this.setVisible(false);
            this.setOpaque(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){};
            this.addMouseMotionListener(mouseInputAdapter);
            this.addMouseListener(mouseInputAdapter);
        }
    }
}

