/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.Rectangle;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

public class LocalStorage
extends AbstractBean {
    private static Logger O = Logger.getLogger(LocalStorage.class.getName());
    private final ApplicationContext P;
    private long M = -1L;
    private _F N = null;
    private final File R;
    private File L = this.R = new File("unspecified");
    private static boolean Q = false;

    protected LocalStorage(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new IllegalArgumentException("null context");
        }
        this.P = applicationContext;
    }

    protected final ApplicationContext getContext() {
        return this.P;
    }

    private void A(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null fileName");
        }
    }

    public InputStream openInputFile(String string) throws IOException {
        this.A(string);
        return this.E().A(string);
    }

    public OutputStream openOutputFile(String string) throws IOException {
        this.A(string);
        return this.E().C(string);
    }

    public boolean deleteFile(String string) throws IOException {
        this.A(string);
        return this.E().B(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Object object, String string) throws IOException {
        _G _G2 = new _G();
        XMLEncoder xMLEncoder = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            xMLEncoder = new XMLEncoder(byteArrayOutputStream);
            if (!Q) {
                xMLEncoder.setPersistenceDelegate(Rectangle.class, new _E());
                Q = true;
            }
            xMLEncoder.setExceptionListener(_G2);
            xMLEncoder.writeObject(object);
        }
        finally {
            if (xMLEncoder != null) {
                xMLEncoder.close();
            }
        }
        if (_G2.A != null) {
            throw new _D("save failed \"" + string + "\"", _G2.A);
        }
        OutputStream outputStream = null;
        try {
            outputStream = this.openOutputFile(string);
            outputStream.write(byteArrayOutputStream.toByteArray());
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(String string) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.openInputFile(string);
        }
        catch (IOException iOException) {
            return null;
        }
        _G _G2 = new _G();
        XMLDecoder xMLDecoder = null;
        try {
            xMLDecoder = new XMLDecoder(inputStream);
            xMLDecoder.setExceptionListener(_G2);
            Object object = xMLDecoder.readObject();
            if (_G2.A != null) {
                throw new _D("load failed \"" + string + "\"", _G2.A);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (xMLDecoder != null) {
                xMLDecoder.close();
            }
        }
    }

    private void A(Closeable closeable, String string) throws IOException {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                throw new _D("close failed \"" + string + "\"", iOException);
            }
        }
    }

    public long getStorageLimit() {
        return this.M;
    }

    public void setStorageLimit(long l) {
        if (l < -1L) {
            throw new IllegalArgumentException("invalid storageLimit");
        }
        long l2 = this.M;
        this.M = l;
        this.firePropertyChange("storageLimit", l2, this.M);
    }

    private String A(String string, String string2) {
        ResourceMap resourceMap = this.getContext().getResourceMap();
        String string3 = resourceMap.getString(string, new Object[0]);
        if (string3 == null) {
            O.log(Level.WARNING, "unspecified resource " + string + " using " + string2);
            string3 = string2;
        } else if (string3.trim().length() == 0) {
            O.log(Level.WARNING, "empty resource " + string + " using " + string2);
            string3 = string2;
        }
        return string3;
    }

    private String F() {
        return this.A("Application.id", this.getContext().getApplicationClass().getSimpleName());
    }

    private String I() {
        return this.A("Application.vendorId", "UnknownApplicationVendor");
    }

    private _B G() {
        PrivilegedAction<String> privilegedAction = new PrivilegedAction<String>(){

            public String A() {
                return System.getProperty("os.name");
            }
        };
        _B _B2 = _B.D;
        String string = AccessController.doPrivileged(privilegedAction);
        if (string != null) {
            if (string.toLowerCase().startsWith("mac os x")) {
                _B2 = _B.B;
            } else if (string.contains("Windows")) {
                _B2 = _B.A;
            }
        }
        return _B2;
    }

    public File getDirectory() {
        if (this.L == this.R) {
            this.L = null;
            String string = null;
            try {
                string = System.getProperty("user.home");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string != null) {
                String string2 = this.F();
                _B _B2 = this.G();
                if (_B2 == _B.A) {
                    String string3;
                    File file = null;
                    try {
                        string3 = System.getenv("APPDATA");
                        if (string3 != null && string3.length() > 0) {
                            file = new File(string3);
                        }
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    string3 = this.I();
                    if (file != null && file.isDirectory()) {
                        String string4 = string3 + "\\" + string2 + "\\";
                        this.L = new File(file, string4);
                    } else {
                        String string5 = "Application Data\\" + string3 + "\\" + string2 + "\\";
                        this.L = new File(string, string5);
                    }
                } else if (_B2 == _B.B) {
                    String string6 = "Library/Application Support/" + string2 + "/";
                    this.L = new File(string, string6);
                } else {
                    String string7 = "." + string2 + "/";
                    this.L = new File(string, string7);
                }
            }
        }
        return this.L;
    }

    public void setDirectory(File file) {
        File file2 = this.L;
        this.L = file;
        this.firePropertyChange("directory", file2, this.L);
    }

    private synchronized _F E() {
        if (this.N == null) {
            this.N = this.H();
            if (this.N == null) {
                this.N = new _A();
            }
        }
        return this.N;
    }

    private _F H() {
        try {
            Class<?> clazz = Class.forName("javax.jnlp.ServiceManager");
            Method method = clazz.getMethod("getServiceNames", new Class[0]);
            String[] stringArray = (String[])method.invoke(null, new Object[0]);
            boolean bl = false;
            boolean bl2 = false;
            for (String string : stringArray) {
                if (string.equals("javax.jnlp.BasicService")) {
                    bl2 = true;
                    continue;
                }
                if (!string.equals("javax.jnlp.PersistenceService")) continue;
                bl = true;
            }
            if (bl2 && bl) {
                return new _C();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static class _G
    implements ExceptionListener {
        public Exception A = null;

        private _G() {
        }

        public void exceptionThrown(Exception exception) {
            if (this.A == null) {
                this.A = exception;
            }
        }
    }

    private static class _D
    extends IOException {
        public _D(String string, Throwable throwable) {
            super(string);
            this.initCause(throwable);
        }

        public _D(String string) {
            super(string);
        }
    }

    private class _A
    extends _F {
        private _A() {
        }

        public InputStream A(String string) throws IOException {
            File file = new File(LocalStorage.this.getDirectory(), string);
            try {
                return new BufferedInputStream(new FileInputStream(file));
            }
            catch (IOException iOException) {
                throw new _D("couldn't open input file \"" + string + "\"", iOException);
            }
        }

        public OutputStream C(String string) throws IOException {
            File file = LocalStorage.this.getDirectory();
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new _D("couldn't create directory " + file);
            }
            File file2 = new File(file, string);
            try {
                return new BufferedOutputStream(new FileOutputStream(file2));
            }
            catch (IOException iOException) {
                throw new _D("couldn't open output file \"" + string + "\"", iOException);
            }
        }

        public boolean B(String string) throws IOException {
            File file = new File(LocalStorage.this.getDirectory(), string);
            return file.delete();
        }
    }

    private abstract class _F {
        private _F() {
        }

        public abstract InputStream A(String var1) throws IOException;

        public abstract OutputStream C(String var1) throws IOException;

        public abstract boolean B(String var1) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum _B {
        A,
        B,
        D;

    }

    private class _C
    extends _F {
        private BasicService B;
        private PersistenceService C;

        private String F(String string) {
            return this.getClass().getName() + " initialization failed: " + string;
        }

        _C() {
            try {
                this.B = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
                this.C = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            }
            catch (UnavailableServiceException unavailableServiceException) {
                O.log(Level.SEVERE, this.F("ServiceManager.lookup"), unavailableServiceException);
                this.B = null;
                this.C = null;
            }
        }

        private void E(String string) throws IOException {
            if (this.B == null || this.C == null) {
                throw new IOException(this.F(string));
            }
        }

        private URL D(String string) throws IOException {
            try {
                return new URL(this.B.getCodeBase(), string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new _D("invalid filename \"" + string + "\"", malformedURLException);
            }
        }

        public InputStream A(String string) throws IOException {
            this.E("openInputFile");
            URL uRL = this.D(string);
            try {
                return new BufferedInputStream(this.C.get(uRL).getInputStream());
            }
            catch (Exception exception) {
                throw new _D("openInputFile \"" + string + "\" failed", exception);
            }
        }

        public OutputStream C(String string) throws IOException {
            this.E("openOutputFile");
            URL uRL = this.D(string);
            try {
                FileContents fileContents;
                block5: {
                    fileContents = null;
                    try {
                        fileContents = this.C.get(uRL);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        long l = 131072L;
                        long l2 = this.C.create(uRL, l);
                        if (l2 < l) break block5;
                        fileContents = this.C.get(uRL);
                    }
                }
                if (fileContents != null && fileContents.canWrite()) {
                    return new BufferedOutputStream(fileContents.getOutputStream(true));
                }
                throw new IOException("unable to create FileContents object");
            }
            catch (Exception exception) {
                throw new _D("openOutputFile \"" + string + "\" failed", exception);
            }
        }

        public boolean B(String string) throws IOException {
            this.E("deleteFile");
            URL uRL = this.D(string);
            try {
                this.C.delete(uRL);
                return true;
            }
            catch (Exception exception) {
                throw new _D("openInputFile \"" + string + "\" failed", exception);
            }
        }
    }

    private static class _E
    extends DefaultPersistenceDelegate {
        public _E() {
            super(new String[]{"x", "y", "width", "height"});
        }

        protected Expression instantiate(Object object, Encoder encoder) {
            Rectangle rectangle = (Rectangle)object;
            Object[] objectArray = new Object[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
            return new Expression(object, object.getClass(), "new", objectArray);
        }
    }
}

