/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionStorage {
    private static Logger B = Logger.getLogger(SessionStorage.class.getName());
    private final Map<Class, Property> A;
    private final ApplicationContext C;

    protected SessionStorage(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new IllegalArgumentException("null context");
        }
        this.C = applicationContext;
        this.A = new HashMap<Class, Property>();
        this.A.put(Window.class, new WindowProperty());
        this.A.put(JTabbedPane.class, new TabbedPaneProperty());
        this.A.put(JSplitPane.class, new SplitPaneProperty());
        this.A.put(JTable.class, new TableProperty());
    }

    protected final ApplicationContext getContext() {
        return this.C;
    }

    private void A(Component component, String string) {
        if (component == null) {
            throw new IllegalArgumentException("null root");
        }
        if (string == null) {
            throw new IllegalArgumentException("null fileName");
        }
    }

    private String A(Component component) {
        return component.getName();
    }

    private String B(Component component) {
        String string = this.A(component);
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        while (component.getParent() != null && !(component instanceof Window) && !(component instanceof Applet)) {
            string = this.A(component = component.getParent());
            if (string == null) {
                int n = component.getParent().getComponentZOrder(component);
                if (n >= 0) {
                    Class<?> clazz = component.getClass();
                    string = clazz.getSimpleName();
                    if (string.length() == 0) {
                        string = "Anonymous" + clazz.getSuperclass().getSimpleName();
                    }
                    string = string + n;
                } else {
                    B.warning("Couldn't compute pathname for " + component);
                    return null;
                }
            }
            stringBuilder.append("/").append(string);
        }
        return stringBuilder.toString();
    }

    private void A(List<Component> list, Map<String, Object> map) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : list) {
            Object object;
            String string;
            Component[] componentArray;
            if (component != null && (componentArray = this.getProperty(component)) != null && (string = this.B(component)) != null && (object = componentArray.getSessionState(component)) != null) {
                map.put(string, object);
            }
            if (!(component instanceof Container) || (componentArray = ((Container)component).getComponents()) == null || componentArray.length <= 0) continue;
            Collections.addAll(arrayList, componentArray);
        }
        if (arrayList.size() > 0) {
            this.A(arrayList, map);
        }
    }

    public void save(Component component, String string) throws IOException {
        this.A(component, string);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.A(Collections.singletonList(component), hashMap);
        LocalStorage localStorage = this.getContext().getLocalStorage();
        localStorage.save(hashMap, string);
    }

    private void B(List<Component> list, Map<String, Object> map) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : list) {
            String string;
            Component[] componentArray;
            if (component != null && (componentArray = this.getProperty(component)) != null && (string = this.B(component)) != null) {
                Object object = map.get(string);
                if (object != null) {
                    componentArray.setSessionState(component, object);
                } else {
                    B.warning("No saved state for " + component);
                }
            }
            if (!(component instanceof Container) || (componentArray = ((Container)component).getComponents()) == null || componentArray.length <= 0) continue;
            Collections.addAll(arrayList, componentArray);
        }
        if (arrayList.size() > 0) {
            this.B(arrayList, map);
        }
    }

    public void restore(Component component, String string) throws IOException {
        this.A(component, string);
        LocalStorage localStorage = this.getContext().getLocalStorage();
        Map map = (Map)localStorage.load(string);
        if (map != null) {
            this.B(Collections.singletonList(component), map);
        }
    }

    private void A(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("null class");
        }
    }

    public Property getProperty(Class clazz) {
        this.A(clazz);
        while (clazz != null) {
            Property property = this.A.get(clazz);
            if (property != null) {
                return property;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public void putProperty(Class clazz, Property property) {
        this.A(clazz);
        this.A.put(clazz, property);
    }

    public final Property getProperty(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (component instanceof Property) {
            return (Property)((Object)component);
        }
        Property property = null;
        if (component instanceof JComponent) {
            Object object = ((JComponent)component).getClientProperty(Property.class);
            property = object instanceof Property ? (Property)object : null;
        }
        return property != null ? property : this.getProperty(component.getClass());
    }

    public static interface Property {
        public Object getSessionState(Component var1);

        public void setSessionState(Component var1, Object var2);
    }

    public static class SplitPaneProperty
    implements Property {
        private void C(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("null component");
            }
            if (!(component instanceof JSplitPane)) {
                throw new IllegalArgumentException("invalid component");
            }
        }

        public Object getSessionState(Component component) {
            this.C(component);
            JSplitPane jSplitPane = (JSplitPane)component;
            return new SplitPaneState(jSplitPane.getUI().getDividerLocation(jSplitPane), jSplitPane.getOrientation());
        }

        public void setSessionState(Component component, Object object) {
            this.C(component);
            if (object != null && !(object instanceof SplitPaneState)) {
                throw new IllegalArgumentException("invalid state");
            }
            JSplitPane jSplitPane = (JSplitPane)component;
            SplitPaneState splitPaneState = (SplitPaneState)object;
            if (jSplitPane.getOrientation() == splitPaneState.getOrientation()) {
                jSplitPane.setDividerLocation(splitPaneState.getDividerLocation());
            }
        }
    }

    public static class SplitPaneState {
        private int B = -1;
        private int A = 1;

        private void A(int n) {
            if (n != 1 && n != 0) {
                throw new IllegalArgumentException("invalid orientation");
            }
        }

        public SplitPaneState() {
        }

        public SplitPaneState(int n, int n2) {
            this.A(n2);
            if (n < -1) {
                throw new IllegalArgumentException("invalid dividerLocation");
            }
            this.B = n;
            this.A = n2;
        }

        public int getDividerLocation() {
            return this.B;
        }

        public void setDividerLocation(int n) {
            if (n < -1) {
                throw new IllegalArgumentException("invalid dividerLocation");
            }
            this.B = n;
        }

        public int getOrientation() {
            return this.A;
        }

        public void setOrientation(int n) {
            this.A(n);
            this.A = n;
        }
    }

    public static class TabbedPaneProperty
    implements Property {
        private void B(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("null component");
            }
            if (!(component instanceof JTabbedPane)) {
                throw new IllegalArgumentException("invalid component");
            }
        }

        public Object getSessionState(Component component) {
            this.B(component);
            JTabbedPane jTabbedPane = (JTabbedPane)component;
            return new TabbedPaneState(jTabbedPane.getSelectedIndex(), jTabbedPane.getTabCount());
        }

        public void setSessionState(Component component, Object object) {
            this.B(component);
            if (object != null && !(object instanceof TabbedPaneState)) {
                throw new IllegalArgumentException("invalid state");
            }
            JTabbedPane jTabbedPane = (JTabbedPane)component;
            TabbedPaneState tabbedPaneState = (TabbedPaneState)object;
            if (jTabbedPane.getTabCount() == tabbedPaneState.getTabCount()) {
                jTabbedPane.setSelectedIndex(tabbedPaneState.getSelectedIndex());
            }
        }
    }

    public static class TabbedPaneState {
        private int A;
        private int B;

        public TabbedPaneState() {
            this.A = -1;
            this.B = 0;
        }

        public TabbedPaneState(int n, int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("invalid tabCount");
            }
            if (n < -1 || n > n2) {
                throw new IllegalArgumentException("invalid selectedIndex");
            }
            this.A = n;
            this.B = n2;
        }

        public int getSelectedIndex() {
            return this.A;
        }

        public void setSelectedIndex(int n) {
            if (n < -1) {
                throw new IllegalArgumentException("invalid selectedIndex");
            }
            this.A = n;
        }

        public int getTabCount() {
            return this.B;
        }

        public void setTabCount(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("invalid tabCount");
            }
            this.B = n;
        }
    }

    public static class TableProperty
    implements Property {
        private void A(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("null component");
            }
            if (!(component instanceof JTable)) {
                throw new IllegalArgumentException("invalid component");
            }
        }

        public Object getSessionState(Component component) {
            this.A(component);
            JTable jTable = (JTable)component;
            int[] nArray = new int[jTable.getColumnCount()];
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
                int n = nArray[i] = tableColumn.getResizable() ? tableColumn.getWidth() : -1;
                if (!tableColumn.getResizable()) continue;
                bl = true;
            }
            return bl ? new TableState(nArray) : null;
        }

        public void setSessionState(Component component, Object object) {
            this.A(component);
            if (!(object instanceof TableState)) {
                throw new IllegalArgumentException("invalid state");
            }
            JTable jTable = (JTable)component;
            int[] nArray = ((TableState)object).getColumnWidths();
            if (jTable.getColumnCount() == nArray.length) {
                for (int i = 0; i < nArray.length; ++i) {
                    TableColumn tableColumn;
                    if (nArray[i] == -1 || !(tableColumn = jTable.getColumnModel().getColumn(i)).getResizable()) continue;
                    tableColumn.setPreferredWidth(nArray[i]);
                }
            }
        }
    }

    public static class TableState {
        private int[] A = new int[0];

        private int[] A(int[] nArray) {
            if (nArray == null) {
                throw new IllegalArgumentException("invalid columnWidths");
            }
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }

        public TableState() {
        }

        public TableState(int[] nArray) {
            this.A = this.A(nArray);
        }

        public int[] getColumnWidths() {
            return this.A(this.A);
        }

        public void setColumnWidths(int[] nArray) {
            this.A = this.A(nArray);
        }
    }

    public static class WindowProperty
    implements Property {
        private void D(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("null component");
            }
            if (!(component instanceof Window)) {
                throw new IllegalArgumentException("invalid component");
            }
        }

        private int A() {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length;
        }

        public Object getSessionState(Component component) {
            GraphicsConfiguration graphicsConfiguration;
            this.D(component);
            int n = 0;
            if (component instanceof Frame) {
                n = ((Frame)component).getExtendedState();
            }
            Rectangle rectangle = (graphicsConfiguration = component.getGraphicsConfiguration()) == null ? null : graphicsConfiguration.getBounds();
            Rectangle rectangle2 = component.getBounds();
            if (component instanceof JFrame && 0 != (n & 6)) {
                String string = "WindowState.normalBounds";
                Object object = ((JFrame)component).getRootPane().getClientProperty(string);
                if (object instanceof Rectangle) {
                    rectangle2 = (Rectangle)object;
                }
            }
            return new WindowState(rectangle2, rectangle, this.A(), n);
        }

        public void setSessionState(Component component, Object object) {
            this.D(component);
            if (object != null && !(object instanceof WindowState)) {
                throw new IllegalArgumentException("invalid state");
            }
            Window window = (Window)component;
            if (!window.isLocationByPlatform() && object != null) {
                WindowState windowState = (WindowState)object;
                Rectangle rectangle = windowState.getGraphicsConfigurationBounds();
                int n = windowState.getScreenCount();
                GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
                Rectangle rectangle2 = graphicsConfiguration == null ? null : graphicsConfiguration.getBounds();
                int n2 = this.A();
                if (rectangle != null && rectangle.equals(rectangle2) && n == n2) {
                    boolean bl = true;
                    if (window instanceof Frame) {
                        bl = ((Frame)window).isResizable();
                    } else if (window instanceof Dialog) {
                        bl = ((Dialog)window).isResizable();
                    }
                    if (bl) {
                        window.setBounds(windowState.getBounds());
                    }
                }
                if (window instanceof Frame) {
                    ((Frame)window).setExtendedState(windowState.getFrameState());
                }
            }
        }
    }

    public static class WindowState {
        private final Rectangle C;
        private Rectangle B = null;
        private int D;
        private int A = 0;

        public WindowState() {
            this.C = new Rectangle();
        }

        public WindowState(Rectangle rectangle, Rectangle rectangle2, int n, int n2) {
            if (rectangle == null) {
                throw new IllegalArgumentException("null bounds");
            }
            if (n < 1) {
                throw new IllegalArgumentException("invalid screenCount");
            }
            this.C = rectangle;
            this.B = rectangle2;
            this.D = n;
            this.A = n2;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.C);
        }

        public void setBounds(Rectangle rectangle) {
            this.C.setBounds(rectangle);
        }

        public int getScreenCount() {
            return this.D;
        }

        public void setScreenCount(int n) {
            this.D = n;
        }

        public int getFrameState() {
            return this.A;
        }

        public void setFrameState(int n) {
            this.A = n;
        }

        public Rectangle getGraphicsConfigurationBounds() {
            return this.B == null ? null : new Rectangle(this.B);
        }

        public void setGraphicsConfigurationBounds(Rectangle rectangle) {
            this.B = rectangle == null ? null : new Rectangle(rectangle);
        }
    }
}

