/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import org.jdesktop.application.Application;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleFrameApplication
extends Application {
    private static final Logger \u00cb = Logger.getLogger(SingleFrameApplication.class.getName());
    private ResourceMap \u00ca = null;
    private FrameView \u00cc = null;

    public final JFrame getMainFrame() {
        return this.getMainView().getFrame();
    }

    protected final void setMainFrame(JFrame jFrame) {
        this.getMainView().setFrame(jFrame);
    }

    private String C(Window window) {
        if (window == null) {
            return null;
        }
        String string = window.getName();
        return string == null ? null : string + ".session.xml";
    }

    protected void configureWindow(Window window) {
        this.getContext().getResourceMap().injectComponents(window);
    }

    private void A(RootPaneContainer rootPaneContainer) {
        Object object;
        JFrame jFrame;
        String string;
        JRootPane jRootPane = rootPaneContainer.getRootPane();
        if (jRootPane.getClientProperty(string = "SingleFrameApplication.initRootPaneContainer") != null) {
            return;
        }
        jRootPane.putClientProperty(string, Boolean.TRUE);
        Container container = jRootPane.getParent();
        if (container instanceof Window) {
            this.configureWindow((Window)container);
        }
        if (rootPaneContainer == (jFrame = this.getMainFrame())) {
            jFrame.addWindowListener(new _A());
            jFrame.setDefaultCloseOperation(0);
        } else if (container instanceof Window) {
            object = (Window)container;
            ((Component)object).addHierarchyListener(new _C());
        }
        if (container instanceof JFrame) {
            container.addComponentListener(new _B());
        }
        if (container instanceof Window) {
            object = (Window)container;
            if (!container.isValid() || container.getWidth() == 0 || container.getHeight() == 0) {
                ((Window)object).pack();
            }
            if (!((Window)object).isLocationByPlatform() && container.getX() == 0 && container.getY() == 0) {
                Window window = ((Window)object).getOwner();
                if (window == null) {
                    window = object != jFrame ? jFrame : null;
                }
                ((Window)object).setLocationRelativeTo(window);
            }
        }
        if (container instanceof Window && (object = this.C((Window)container)) != null) {
            try {
                this.getContext().getSessionStorage().restore(container, (String)object);
            }
            catch (Exception exception) {
                String string2 = String.format("couldn't restore sesssion [%s]", object);
                \u00cb.log(Level.WARNING, string2, exception);
            }
        }
    }

    protected void show(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException("null JComponent");
        }
        JFrame jFrame = this.getMainFrame();
        jFrame.getContentPane().add((Component)jComponent, "Center");
        this.A(jFrame);
        jFrame.setVisible(true);
    }

    public void show(JDialog jDialog) {
        if (jDialog == null) {
            throw new IllegalArgumentException("null JDialog");
        }
        this.A(jDialog);
        jDialog.setVisible(true);
    }

    public void show(JFrame jFrame) {
        if (jFrame == null) {
            throw new IllegalArgumentException("null JFrame");
        }
        this.A(jFrame);
        jFrame.setVisible(true);
    }

    private void A(Window window) {
        String string = this.C(window);
        if (string != null) {
            try {
                this.getContext().getSessionStorage().save(window, string);
            }
            catch (IOException iOException) {
                \u00cb.log(Level.WARNING, "couldn't save sesssion", iOException);
            }
        }
    }

    private boolean B(Window window) {
        return window.isVisible() && (window instanceof JFrame || window instanceof JDialog || window instanceof JWindow);
    }

    private List<Window> a() {
        ArrayList<Window> arrayList;
        block8: {
            block7: {
                arrayList = new ArrayList<Window>();
                Method method = null;
                try {
                    method = Window.class.getMethod("getWindows", new Class[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (method == null) break block7;
                Window[] windowArray = null;
                try {
                    windowArray = (Window[])method.invoke(null, new Object[0]);
                }
                catch (Exception exception) {
                    throw new Error("HCTB - can't get top level windows list", exception);
                }
                if (windowArray == null) break block8;
                for (Window window : windowArray) {
                    if (!this.B(window)) continue;
                    arrayList.add(window);
                }
                break block8;
            }
            Frame[] frameArray = Frame.getFrames();
            if (frameArray != null) {
                for (Frame frame : frameArray) {
                    if (!this.B(frame)) continue;
                    arrayList.add(frame);
                }
            }
        }
        return arrayList;
    }

    @Override
    protected void shutdown() {
        this.A(this.getMainFrame());
        for (Window window : this.a()) {
            this.A(window);
        }
    }

    public FrameView getMainView() {
        if (this.\u00cc == null) {
            this.\u00cc = new FrameView(this);
        }
        return this.\u00cc;
    }

    @Override
    public void show(View view) {
        if (this.\u00cc == null && view instanceof FrameView) {
            this.\u00cc = (FrameView)view;
        }
        RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)view.getRootPane().getParent());
        this.A(rootPaneContainer);
        ((Window)((Object)rootPaneContainer)).setVisible(true);
    }

    private static class _B
    implements ComponentListener {
        private _B() {
        }

        private void A(ComponentEvent componentEvent) {
            JFrame jFrame;
            if (componentEvent.getComponent() instanceof JFrame && ((jFrame = (JFrame)componentEvent.getComponent()).getExtendedState() & 6) == 0) {
                String string = "WindowState.normalBounds";
                jFrame.getRootPane().putClientProperty(string, jFrame.getBounds());
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.A(componentEvent);
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }
    }

    private class _A
    extends WindowAdapter {
        private _A() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            SingleFrameApplication.this.exit(windowEvent);
        }
    }

    private class _C
    implements HierarchyListener {
        private _C() {
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            Window window;
            if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && hierarchyEvent.getSource() instanceof Window && !(window = (Window)hierarchyEvent.getSource()).isShowing()) {
                SingleFrameApplication.this.A(window);
            }
        }
    }
}

