/*
 * Decompiled with CFR 0.152.
 */
package secureSWF.plugin;

import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import secureSWF.G.E;
import secureSWF.gui.JFrameMain;

public class Export2SecureSwfToolbarAction
implements IWorkbenchWindowActionDelegate {
    private JFrameMain jFrameMain;
    private final List<File> files = new ArrayList<File>();

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (this.jFrameMain == null) {
            try {
                this.jFrameMain = new JFrameMain();
            }
            catch (E e1) {
                e1.printStackTrace();
            }
        }
        File projectFile = null;
        for (File file : this.files) {
            if (!file.getPath().toUpperCase().endsWith(".SSPJ")) continue;
            projectFile = file;
            break;
        }
        if (projectFile == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Export2SecureSwfToolbarAction.this.jFrameMain.A(Export2SecureSwfToolbarAction.this.files.toArray(new File[0]));
                }
            });
        } else {
            final File f = new File(projectFile.getAbsolutePath());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Export2SecureSwfToolbarAction.this.jFrameMain.A(f, false);
                    }
                    catch (HeadlessException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchAlgorithmException e) {
                        e.printStackTrace();
                    }
                    catch (E e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        this.jFrameMain.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Export2SecureSwfToolbarAction.this.jFrameMain = null;
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.files.clear();
        if (selection.isEmpty()) {
            return;
        }
        if (selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            int i = 0;
            while (i < treeSelection.getPaths().length) {
                Object item = treeSelection.getPaths()[i].getSegment(0);
                if (item instanceof IProject) {
                    IProject project = (IProject)item;
                    this.files.addAll(this.iterateDir(new File(project.getWorkspace().getRoot().getLocation().toOSString(), project.getFullPath().toString().substring(1))));
                } else if (item instanceof IFile) {
                    IFile file = (IFile)item;
                    this.files.addAll(this.iterateDir(new File(file.getWorkspace().getRoot().getLocation().toOSString(), file.getFullPath().toOSString())));
                } else if (item instanceof IFolder) {
                    IFolder folder = (IFolder)item;
                    this.files.addAll(this.iterateDir(new File(folder.getWorkspace().getRoot().getLocation().toOSString(), folder.getFullPath().toOSString())));
                }
                ++i;
            }
        }
    }

    private List<File> iterateDir(File baseDir) {
        ArrayList<File> secureSWF_Files = new ArrayList<File>();
        if (baseDir != null && baseDir.exists() && baseDir.canRead()) {
            String baseDirPath = baseDir.getPath().toUpperCase();
            if (baseDir.isFile() && (baseDirPath.endsWith(".SWF") || baseDirPath.endsWith(".SWC") || baseDirPath.endsWith(".AIR") || baseDirPath.endsWith(".SSPJ"))) {
                secureSWF_Files.add(baseDir);
                return secureSWF_Files;
            }
            File[] subFiles = baseDir.listFiles();
            int i = 0;
            while (i < subFiles.length) {
                String path = subFiles[i].getPath().toUpperCase();
                if (subFiles[i].isDirectory()) {
                    secureSWF_Files.addAll(this.iterateDir(subFiles[i]));
                } else if (path.endsWith(".SWF") || path.endsWith(".SWC") || path.endsWith(".AIR") || path.endsWith(".SSPJ")) {
                    secureSWF_Files.add(subFiles[i]);
                }
                ++i;
            }
        }
        return secureSWF_Files;
    }
}

