/*
 * Decompiled with CFR 0.152.
 */
package secureSWF.plugin.builder;

import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import secureSWF.G.E;
import secureSWF.gui.JFrameMain;

public class ExportWizard
extends Wizard
implements IExportWizard {
    private JFrameMain jFrameMain;
    private IStructuredSelection selection;

    public ExportWizard() {
        WizardPage secureSWF_Page = new WizardPage("secureSWF"){
            private Label lbl;

            public void createControl(Composite parent) {
                this.lbl = new Label(parent, 64);
                this.lbl.setText("Protect With secureSWF");
                super.setControl((Control)this.lbl);
            }

            public Control getControl() {
                return this.lbl;
            }
        };
        secureSWF_Page.setTitle("Proect with secureSWF");
        secureSWF_Page.setPageComplete(true);
        super.addPage((IWizardPage)secureSWF_Page);
        try {
            this.jFrameMain = new JFrameMain();
        }
        catch (E e) {
            e.printStackTrace();
        }
    }

    public boolean performFinish() {
        final ArrayList<File> files = new ArrayList<File>();
        if (this.selection.isEmpty()) {
            return true;
        }
        for (Object next : this.selection) {
            if (next instanceof IProject) {
                IProject iProject = (IProject)next;
                files.addAll(this.iterateDir(new File(iProject.getWorkspace().getRoot().getLocation().toOSString(), iProject.getFullPath().toString().substring(1))));
                continue;
            }
            if (next instanceof IFile) {
                IFile iFile = (IFile)next;
                files.addAll(this.iterateDir(new File(iFile.getWorkspace().getRoot().getLocation().toOSString(), iFile.getFullPath().toOSString())));
                continue;
            }
            if (!(next instanceof IFolder)) continue;
            IFolder iFolder = (IFolder)next;
            files.addAll(this.iterateDir(new File(iFolder.getWorkspace().getRoot().getLocation().toOSString(), iFolder.getFullPath().toOSString())));
        }
        try {
            this.jFrameMain = new JFrameMain();
            this.jFrameMain.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    super.windowClosed(e);
                    ExportWizard.this.dispose();
                }
            });
            File projectFile = null;
            for (File file : files) {
                if (!file.getPath().toUpperCase().endsWith(".SSPJ")) continue;
                projectFile = file;
                break;
            }
            if (projectFile == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExportWizard.this.jFrameMain.A(files.toArray(new File[0]));
                    }
                });
            } else {
                final File file = new File(projectFile.getAbsolutePath());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ExportWizard.this.jFrameMain.A(file, false);
                        }
                        catch (HeadlessException e) {
                            e.printStackTrace();
                        }
                        catch (NoSuchAlgorithmException e) {
                            e.printStackTrace();
                        }
                        catch (E e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            this.jFrameMain.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExportWizard.this.jFrameMain = null;
                }
            });
        }
        catch (E e) {
            e.printStackTrace();
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.jFrameMain == null ? 0 : this.jFrameMain.hashCode());
        result = 31 * result + (this.selection == null ? 0 : this.selection.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ExportWizard other = (ExportWizard)((Object)obj);
        if (this.jFrameMain == null ? other.jFrameMain != null : !this.jFrameMain.equals(other.jFrameMain)) {
            return false;
        }
        return !(this.selection == null ? other.selection != null : !this.selection.equals(other.selection));
    }

    private List<File> iterateDir(File baseDir) {
        ArrayList<File> secureSWF_Files = new ArrayList<File>();
        if (baseDir != null && baseDir.exists() && baseDir.canRead()) {
            String baseDirPath = baseDir.getPath().toUpperCase();
            if (baseDir.isFile() && (baseDirPath.endsWith(".SWF") || baseDirPath.endsWith(".SWC") || baseDirPath.endsWith(".AIR") || baseDirPath.endsWith(".APK") || baseDirPath.endsWith(".SSPJ"))) {
                secureSWF_Files.add(baseDir);
                return secureSWF_Files;
            }
            File[] subFiles = baseDir.listFiles();
            int i = 0;
            while (i < subFiles.length) {
                String path = subFiles[i].getPath().toUpperCase();
                if (subFiles[i].isDirectory()) {
                    secureSWF_Files.addAll(this.iterateDir(subFiles[i]));
                } else if (path.endsWith(".SWF") || path.endsWith(".SWC") || path.endsWith(".AIR") || path.endsWith(".APK") || path.endsWith(".SSPJ")) {
                    secureSWF_Files.add(subFiles[i]);
                }
                ++i;
            }
        }
        return secureSWF_Files;
    }
}

