/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.ActionManager;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.ResourceManager;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SessionStorage;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.application.TaskService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationContext
extends AbstractBean {
    private static final Logger \u00b5 = Logger.getLogger(ApplicationContext.class.getName());
    private final List<TaskService> w;
    private final List<TaskService> u;
    private ResourceManager y = new ResourceManager(this);
    private ActionManager \u00a2 = new ActionManager(this);
    private LocalStorage \u00ba = new LocalStorage(this);
    private SessionStorage \u00a4 = new SessionStorage(this);
    private Application \u00a3 = null;
    private Class v = null;
    private JComponent \u00aa = null;
    private Clipboard x = null;
    private Throwable \u00a5 = null;
    private TaskMonitor z = null;

    protected ApplicationContext() {
        this.w = new CopyOnWriteArrayList<TaskService>();
        this.w.add(new TaskService("default"));
        this.u = Collections.unmodifiableList(this.w);
    }

    public final synchronized Class getApplicationClass() {
        return this.v;
    }

    public final synchronized void setApplicationClass(Class clazz) {
        if (this.\u00a3 != null) {
            throw new IllegalStateException("application has been launched");
        }
        this.v = clazz;
    }

    public final synchronized Application getApplication() {
        return this.\u00a3;
    }

    synchronized void A(Application application) {
        if (this.\u00a3 != null) {
            throw new IllegalStateException("application has already been launched");
        }
        this.\u00a3 = application;
    }

    public final ResourceManager getResourceManager() {
        return this.y;
    }

    protected void setResourceManager(ResourceManager resourceManager) {
        if (resourceManager == null) {
            throw new IllegalArgumentException("null resourceManager");
        }
        ResourceManager resourceManager2 = this.y;
        this.y = resourceManager;
        this.firePropertyChange("resourceManager", resourceManager2, this.y);
    }

    public final ResourceMap getResourceMap(Class clazz) {
        return this.getResourceManager().getResourceMap(clazz, clazz);
    }

    public final ResourceMap getResourceMap(Class clazz, Class clazz2) {
        return this.getResourceManager().getResourceMap(clazz, clazz2);
    }

    public final ResourceMap getResourceMap() {
        return this.getResourceManager().getResourceMap();
    }

    public final ActionManager getActionManager() {
        return this.\u00a2;
    }

    protected void setActionManager(ActionManager actionManager) {
        if (actionManager == null) {
            throw new IllegalArgumentException("null actionManager");
        }
        ActionManager actionManager2 = this.\u00a2;
        this.\u00a2 = actionManager;
        this.firePropertyChange("actionManager", actionManager2, this.\u00a2);
    }

    public final ApplicationActionMap getActionMap() {
        return this.getActionManager().getActionMap();
    }

    public final ApplicationActionMap getActionMap(Class clazz, Object object) {
        return this.getActionManager().getActionMap(clazz, object);
    }

    public final ApplicationActionMap getActionMap(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null actionsObject");
        }
        return this.getActionManager().getActionMap(object.getClass(), object);
    }

    public final LocalStorage getLocalStorage() {
        return this.\u00ba;
    }

    protected void setLocalStorage(LocalStorage localStorage) {
        if (localStorage == null) {
            throw new IllegalArgumentException("null localStorage");
        }
        LocalStorage localStorage2 = this.\u00ba;
        this.\u00ba = localStorage;
        this.firePropertyChange("localStorage", localStorage2, this.\u00ba);
    }

    public final SessionStorage getSessionStorage() {
        return this.\u00a4;
    }

    protected void setSessionStorage(SessionStorage sessionStorage) {
        if (sessionStorage == null) {
            throw new IllegalArgumentException("null sessionStorage");
        }
        SessionStorage sessionStorage2 = this.\u00a4;
        this.\u00a4 = sessionStorage;
        this.firePropertyChange("sessionStorage", sessionStorage2, this.\u00a4);
    }

    public Clipboard getClipboard() {
        if (this.x == null) {
            try {
                this.x = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (SecurityException securityException) {
                this.x = new Clipboard("sandbox");
            }
        }
        return this.x;
    }

    public JComponent getFocusOwner() {
        return this.\u00aa;
    }

    void A(JComponent jComponent) {
        JComponent jComponent2 = this.\u00aa;
        this.\u00aa = jComponent;
        this.firePropertyChange("focusOwner", jComponent2, this.\u00aa);
    }

    private List<TaskService> T() {
        return new ArrayList<TaskService>(this.w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskService(TaskService taskService) {
        if (taskService == null) {
            throw new IllegalArgumentException("null taskService");
        }
        List<TaskService> list = null;
        List<TaskService> list2 = null;
        boolean bl = false;
        List<TaskService> list3 = this.w;
        synchronized (list3) {
            if (!this.w.contains(taskService)) {
                list = this.T();
                this.w.add(taskService);
                list2 = this.T();
                bl = true;
            }
        }
        if (bl) {
            this.firePropertyChange("taskServices", list, list2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskService(TaskService taskService) {
        if (taskService == null) {
            throw new IllegalArgumentException("null taskService");
        }
        List<TaskService> list = null;
        List<TaskService> list2 = null;
        boolean bl = false;
        List<TaskService> list3 = this.w;
        synchronized (list3) {
            if (this.w.contains(taskService)) {
                list = this.T();
                this.w.remove(taskService);
                list2 = this.T();
                bl = true;
            }
        }
        if (bl) {
            this.firePropertyChange("taskServices", list, list2);
        }
    }

    public TaskService getTaskService(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null name");
        }
        for (TaskService taskService : this.w) {
            if (!string.equals(taskService.getName())) continue;
            return taskService;
        }
        return null;
    }

    public final TaskService getTaskService() {
        return this.getTaskService("default");
    }

    public List<TaskService> getTaskServices() {
        return this.u;
    }

    public final TaskMonitor getTaskMonitor() {
        if (this.z == null) {
            this.z = new TaskMonitor(this);
        }
        return this.z;
    }
}

