/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationAction;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;
import org.jdesktop.application.TaskService;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Task<T, V>
extends SwingWorker<T, V> {
    private static final Logger N = Logger.getLogger(Task.class.getName());
    private final Application I;
    private String H;
    private ResourceMap B;
    private List<TaskListener<T, V>> O;
    private InputBlocker G;
    private String C = null;
    private String K = null;
    private String M = null;
    private long A = -1L;
    private String P = null;
    private long D = -1L;
    private long L = -1L;
    private boolean F = true;
    private boolean J = false;
    private TaskService E = null;

    private void A(ResourceMap resourceMap, String string) {
        this.B = resourceMap;
        this.H = string == null || string.length() == 0 ? "" : (string.endsWith(".") ? string : string + ".");
        if (resourceMap != null) {
            this.K = resourceMap.getString(this.resourceName("title"), new Object[0]);
            this.M = resourceMap.getString(this.resourceName("description"), new Object[0]);
            this.P = resourceMap.getString(this.resourceName("message"), new Object[0]);
            if (this.P != null) {
                this.A = System.currentTimeMillis();
            }
        }
        this.addPropertyChangeListener(new _A());
        this.O = new CopyOnWriteArrayList<TaskListener<T, V>>();
    }

    private ResourceMap A(Application application) {
        return application.getContext().getResourceMap(this.getClass(), Task.class);
    }

    @Deprecated
    public Task(Application application, ResourceMap resourceMap, String string) {
        this.I = application;
        this.A(resourceMap, string);
    }

    @Deprecated
    public Task(Application application, String string) {
        this.I = application;
        this.A(this.A(application), string);
    }

    public Task(Application application) {
        this.I = application;
        this.A(this.A(application), "");
    }

    public final Application getApplication() {
        return this.I;
    }

    public final ApplicationContext getContext() {
        return this.getApplication().getContext();
    }

    public synchronized TaskService getTaskService() {
        return this.E;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void A(TaskService taskService) {
        TaskService taskService2;
        TaskService taskService3;
        Task task = this;
        synchronized (task) {
            taskService3 = this.E;
            taskService2 = this.E = taskService;
        }
        this.firePropertyChange("taskService", taskService3, taskService2);
    }

    protected final String resourceName(String string) {
        return this.H + string;
    }

    public final ResourceMap getResourceMap() {
        return this.B;
    }

    public synchronized String getTitle() {
        return this.K;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTitle(String string) {
        String string2;
        String string3;
        Task task = this;
        synchronized (task) {
            string3 = this.K;
            string2 = this.K = string;
        }
        this.firePropertyChange("title", string3, string2);
    }

    public synchronized String getDescription() {
        return this.M;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDescription(String string) {
        String string2;
        String string3;
        Task task = this;
        synchronized (task) {
            string3 = this.M;
            string2 = this.M = string;
        }
        this.firePropertyChange("description", string3, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExecutionDuration(TimeUnit timeUnit) {
        long l;
        long l2;
        Task task = this;
        synchronized (task) {
            l2 = this.D;
            l = this.L;
        }
        long l3 = l2 == -1L ? 0L : (l == -1L ? System.currentTimeMillis() - l2 : l - l2);
        return timeUnit.convert(Math.max(0L, l3), TimeUnit.MILLISECONDS);
    }

    public String getMessage() {
        return this.P;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMessage(String string) {
        String string2;
        String string3;
        Task task = this;
        synchronized (task) {
            string3 = this.P;
            string2 = this.P = string;
            this.A = System.currentTimeMillis();
        }
        this.firePropertyChange("message", string3, string2);
    }

    protected final void message(String string, Object ... objectArray) {
        ResourceMap resourceMap = this.getResourceMap();
        if (resourceMap != null) {
            this.setMessage(resourceMap.getString(this.resourceName(string), objectArray));
        } else {
            this.setMessage(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessageDuration(TimeUnit timeUnit) {
        long l;
        Task task = this;
        synchronized (task) {
            l = this.A;
        }
        long l2 = l == -1L ? 0L : Math.max(0L, System.currentTimeMillis() - l);
        return timeUnit.convert(l2, TimeUnit.MILLISECONDS);
    }

    public synchronized boolean getUserCanCancel() {
        return this.F;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUserCanCancel(boolean bl) {
        boolean bl2;
        boolean bl3;
        Task task = this;
        synchronized (task) {
            bl3 = this.F;
            bl2 = this.F = bl;
        }
        this.firePropertyChange("userCanCancel", bl3, bl2);
    }

    public synchronized boolean isProgressPropertyValid() {
        return this.J;
    }

    protected final void setProgress(int n, int n2, int n3) {
        if (n2 >= n3) {
            throw new IllegalArgumentException("invalid range: min >= max");
        }
        if (n < n2 || n > n3) {
            throw new IllegalArgumentException("invalid value");
        }
        float f = (float)(n - n2) / (float)(n3 - n2);
        this.setProgress(Math.round(f * 100.0f));
    }

    protected final void setProgress(float f) {
        if ((double)f < 0.0 || (double)f > 1.0) {
            throw new IllegalArgumentException("invalid percentage");
        }
        this.setProgress(Math.round(f * 100.0f));
    }

    protected final void setProgress(float f, float f2, float f3) {
        if (f2 >= f3) {
            throw new IllegalArgumentException("invalid range: min >= max");
        }
        if (f < f2 || f > f3) {
            throw new IllegalArgumentException("invalid value");
        }
        float f4 = (f - f2) / (f3 - f2);
        this.setProgress(Math.round(f4 * 100.0f));
    }

    public final boolean isPending() {
        return this.getState() == SwingWorker.StateValue.PENDING;
    }

    public final boolean isStarted() {
        return this.getState() == SwingWorker.StateValue.STARTED;
    }

    @Override
    protected void process(List<V> list) {
        this.A((T)list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void done() {
        try {
            if (this.isCancelled()) {
                this.cancelled();
            } else {
                try {
                    this.succeeded(this.get());
                }
                catch (InterruptedException interruptedException) {
                    this.interrupted(interruptedException);
                }
                catch (ExecutionException executionException) {
                    this.failed(executionException.getCause());
                }
            }
        }
        finally {
            try {
                this.finished();
            }
            finally {
                this.A((TaskService)null);
            }
        }
    }

    protected void cancelled() {
    }

    protected void succeeded(T t) {
    }

    protected void interrupted(InterruptedException interruptedException) {
    }

    protected void failed(Throwable throwable) {
        String string = String.format("%s failed: %s", this, throwable);
        N.log(Level.SEVERE, string, throwable);
    }

    protected void finished() {
    }

    public void addTaskListener(TaskListener<T, V> taskListener) {
        if (taskListener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.O.add(taskListener);
    }

    public void removeTaskListener(TaskListener<T, V> taskListener) {
        if (taskListener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.O.remove(taskListener);
    }

    public TaskListener<T, V>[] getTaskListeners() {
        return this.O.toArray(new TaskListener[this.O.size()]);
    }

    private void A(List<V> list) {
        TaskEvent<List<V>> taskEvent = new TaskEvent<List<V>>(this, list);
        for (TaskListener<T, V> taskListener : this.O) {
            taskListener.process(taskEvent);
        }
    }

    private void A() {
        TaskEvent<Object> taskEvent = new TaskEvent<Object>(this, null);
        for (TaskListener<T, V> taskListener : this.O) {
            taskListener.doInBackground(taskEvent);
        }
    }

    private void A(T t) {
        TaskEvent<T> taskEvent = new TaskEvent<T>(this, t);
        for (TaskListener<T, V> taskListener : this.O) {
            taskListener.succeeded(taskEvent);
        }
    }

    private void D() {
        TaskEvent<Object> taskEvent = new TaskEvent<Object>(this, null);
        for (TaskListener<T, V> taskListener : this.O) {
            taskListener.cancelled(taskEvent);
        }
    }

    private void A(InterruptedException interruptedException) {
        TaskEvent<InterruptedException> taskEvent = new TaskEvent<InterruptedException>(this, interruptedException);
        for (TaskListener<T, V> taskListener : this.O) {
            taskListener.interrupted(taskEvent);
        }
    }

    private void A(Throwable throwable) {
        TaskEvent<Throwable> taskEvent = new TaskEvent<Throwable>(this, throwable);
        for (TaskListener<T, V> taskListener : this.O) {
            taskListener.failed(taskEvent);
        }
    }

    private void C() {
        TaskEvent<Object> taskEvent = new TaskEvent<Object>(this, null);
        for (TaskListener<T, V> taskListener : this.O) {
            taskListener.finished(taskEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void B() {
        try {
            if (this.isCancelled()) {
                this.D();
            } else {
                try {
                    this.A(this.get());
                }
                catch (InterruptedException interruptedException) {
                    this.A(interruptedException);
                }
                catch (ExecutionException executionException) {
                    this.A(executionException.getCause());
                }
            }
        }
        finally {
            this.C();
        }
    }

    public final InputBlocker getInputBlocker() {
        return this.G;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInputBlocker(InputBlocker inputBlocker) {
        InputBlocker inputBlocker2;
        InputBlocker inputBlocker3;
        if (this.getTaskService() != null) {
            throw new IllegalStateException("task already being executed");
        }
        Task task = this;
        synchronized (task) {
            inputBlocker3 = this.G;
            inputBlocker2 = this.G = inputBlocker;
        }
        this.firePropertyChange("inputBlocker", inputBlocker3, inputBlocker2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlockingScope {
        NONE,
        ACTION,
        COMPONENT,
        WINDOW,
        APPLICATION;

    }

    public static abstract class InputBlocker
    extends AbstractBean {
        private final Task B;
        private final BlockingScope C;
        private final Object E;
        private final ApplicationAction D;

        public InputBlocker(Task task, BlockingScope blockingScope, Object object, ApplicationAction applicationAction) {
            if (task == null) {
                throw new IllegalArgumentException("null task");
            }
            if (task.getTaskService() != null) {
                throw new IllegalStateException("task already being executed");
            }
            switch (blockingScope) {
                case ACTION: {
                    if (object instanceof Action) break;
                    throw new IllegalArgumentException("target not an Action");
                }
                case COMPONENT: 
                case WINDOW: {
                    if (object instanceof Component) break;
                    throw new IllegalArgumentException("target not a Component");
                }
            }
            this.B = task;
            this.C = blockingScope;
            this.E = object;
            this.D = applicationAction;
        }

        public InputBlocker(Task task, BlockingScope blockingScope, Object object) {
            this(task, blockingScope, object, object instanceof ApplicationAction ? (ApplicationAction)object : null);
        }

        public final Task getTask() {
            return this.B;
        }

        public final BlockingScope getScope() {
            return this.C;
        }

        public final Object getTarget() {
            return this.E;
        }

        public final ApplicationAction getAction() {
            return this.D;
        }

        protected abstract void block();

        protected abstract void unblock();
    }

    private class _A
    implements PropertyChangeListener {
        private _A() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("state".equals(string)) {
                SwingWorker.StateValue stateValue = (SwingWorker.StateValue)((Object)propertyChangeEvent.getNewValue());
                Task task = (Task)propertyChangeEvent.getSource();
                switch (stateValue) {
                    case STARTED: {
                        this.B(task);
                        break;
                    }
                    case DONE: {
                        this.A(task);
                    }
                }
            } else if ("progress".equals(string)) {
                Task task = Task.this;
                synchronized (task) {
                    Task.this.J = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void B(Task task) {
            Task task2 = Task.this;
            synchronized (task2) {
                Task.this.D = System.currentTimeMillis();
            }
            Task.this.firePropertyChange("started", false, true);
            Task.this.A();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void A(Task task) {
            Task task2 = Task.this;
            synchronized (task2) {
                Task.this.L = System.currentTimeMillis();
            }
            try {
                task.removePropertyChangeListener(this);
                Task.this.firePropertyChange("done", false, true);
                Task.this.B();
            }
            finally {
                Task.this.firePropertyChange("completed", false, true);
            }
        }
    }
}

