/*
 * Decompiled with CFR 0.152.
 */
package secureSWF.components.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.FontFactory;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Section;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.ResourceBundle;
import secureSWF.components.pdf.PDFTable;
import secureSWF.settings.EncryptionString;
import secureSWF.settings.Identifier;
import secureSWF.settings.SwfFileInfo;
import secureSWF.settings.SwfProcessingSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfBuilder {
    private final SwfFileInfo[] F;
    private Identifier[] G;
    private final Document A;
    private Chapter C;
    private Chapter E;
    private Section H;
    private final SwfProcessingSettings D;
    private final String B = "3.6";

    PdfBuilder(String string, SwfProcessingSettings swfProcessingSettings) throws DocumentException, FileNotFoundException {
        this.D = swfProcessingSettings;
        this.F = this.D.getSwfFiles();
        this.A = new Document();
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        PdfWriter.getInstance((Document)this.A, (OutputStream)new FileOutputStream(file));
    }

    private Paragraph A(int n, int n2) {
        Paragraph paragraph = new Paragraph();
        for (int i = 0; i < n; ++i) {
            Phrase phrase = new Phrase(Chunk.NEWLINE);
            paragraph.add((Object)phrase);
        }
        paragraph.setAlignment(n2);
        return paragraph;
    }

    void A() throws IOException, DocumentException {
        if (this.F == null) {
            return;
        }
        HeaderFooter headerFooter = new HeaderFooter(new Phrase("", FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)0, (Color)Color.BLACK)), true);
        headerFooter.setAlignment(1);
        headerFooter.setBorder(0);
        Phrase phrase = new Phrase(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("header"), FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)0, (Color)Color.BLACK));
        HeaderFooter headerFooter2 = new HeaderFooter(phrase, true);
        headerFooter2.setBorderColor(Color.GRAY);
        this.A.setHeader(headerFooter2);
        this.A.setFooter(headerFooter);
        Image image = Image.getInstance((URL)this.getClass().getResource("images/KindisoftLogo.jpg"));
        image.scalePercent(20.0f, 20.0f);
        image.setAlignment(1);
        Image image2 = Image.getInstance((URL)this.getClass().getResource("images/image1.jpg"));
        image2.scalePercent(100.0f, 100.0f);
        image2.setAlignment(1);
        image2.setBorder(15);
        image2.setBorderColor(Color.GRAY);
        image2.setBorderWidth(0.3f);
        this.A.open();
        this.A.add((Element)this.A(8, 1));
        this.A.addTitle(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Summary"));
        this.A.addAuthor(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("secureSWF"));
        this.A.addCreationDate();
        this.A.addCreator(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("secureSWF"));
        this.A.add((Element)image);
        this.A.add((Element)Chunk.NEWLINE);
        this.A.add((Element)Chunk.NEWLINE);
        this.A.add((Element)image2);
        Paragraph paragraph = new Paragraph(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Summary_of_Obfuscating_Your_File"), FontFactory.getFont((String)"Times-Roman", (float)18.0f, (int)0, (Color)Color.BLACK));
        paragraph.setAlignment(1);
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy, MMMM");
        Paragraph paragraph2 = new Paragraph("", FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)0, (Color)Color.BLACK));
        paragraph2.add((Object)("\n" + simpleDateFormat.format(calendar.getTime())));
        paragraph2.setAlignment(2);
        paragraph.add((Object)"\n Version 3.6");
        this.A.add((Element)paragraph);
        this.A.add((Element)Chunk.NEWLINE);
        this.A.add((Element)Chunk.NEWLINE);
        this.A.add((Element)paragraph2);
        this.A.newPage();
        this.A.add((Element)new Paragraph(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Files"), FontFactory.getFont((String)"Times-Roman", (float)16.0f, (int)4, (Color)Color.BLACK)));
        String string = "";
        for (int i = 0; i < this.D.getSwfFiles().length; ++i) {
            string = string + this.D.getSwfFiles()[i].getFileName() + ", ";
        }
        if (this.D.getSwfFiles().length > 1) {
            string = string.substring(0, string.lastIndexOf(","));
        }
        string = string + ".\n";
        Paragraph paragraph3 = new Paragraph(string, FontFactory.getFont((String)"Times-Roman", (float)14.0f, (int)0, (Color)Color.BLACK));
        this.A.add((Element)paragraph3);
        this.B();
        for (int i = 0; i < this.F.length; ++i) {
            Paragraph paragraph4 = new Paragraph(this.F[i].getFileName(), FontFactory.getFont((String)"Times-Roman", (float)16.0f, (int)0, (Color)Color.BLACK));
            paragraph4.setAlignment(0);
            paragraph4.setSpacingBefore(20.0f);
            paragraph4.setSpacingAfter(5.0f);
            this.E = new Chapter(paragraph4, i + 1);
            this.E.setNumberDepth(2);
            this.E.setIndentationRight(5.0f);
            this.E.setTriggerNewPage(false);
            this.A.add((Element)this.E);
            if (this.D.isGenerateMapFile()) {
                Paragraph paragraph5 = new Paragraph(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Map_file") + this.D.getSwfFiles()[i].getFileName().substring(0, this.D.getSwfFiles()[i].getFileName().indexOf(".")) + ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("_map.xml"), FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)0, (Color)Color.BLACK));
                this.A.add((Element)paragraph5);
            }
            this.A(i);
            if (this.D.isRenameIdentifiers()) {
                this.D(i);
            }
            this.C(i);
            this.C();
            this.B(i);
            this.A(this.F[i]);
            this.B(this.F[i]);
        }
        Paragraph paragraph6 = new Paragraph(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Thank_you_for_using_secureSWF"), FontFactory.getFont((String)"Times-Roman", (float)14.0f, (int)0, (Color)Color.BLACK));
        this.A.add((Element)paragraph6);
        this.A.close();
    }

    private void C(int n) throws DocumentException {
        Paragraph paragraph;
        PDFTable pDFTable = new PDFTable(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Name"), ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Type"), ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Symbol")}, new float[]{2.0f, 1.0f, 1.0f});
        for (int i = 0; i < this.D.getSwfFiles()[n].getMovieClips().length; ++i) {
            paragraph = this.D.getSwfFiles()[n].getMovieClips()[i].getLabels();
            for (int j = 0; j < ((Identifier[])paragraph).length; ++j) {
                pDFTable.addRow(new String[]{paragraph[j].getName(), paragraph[j].getType(), this.D.getSwfFiles()[n].getMovieClips()[i].getMovieClipName()});
            }
        }
        if (pDFTable.getRowCount() > 0) {
            String string = ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Labels_Table");
            paragraph = new Paragraph(string, FontFactory.getFont((String)"Times-Roman", (float)14.0f, (int)0, (Color)Color.RED));
            paragraph.setSpacingAfter(5.0f);
            this.A.add((Element)paragraph);
            this.A(pDFTable, 85, false);
        }
    }

    private void B(SwfFileInfo swfFileInfo) throws DocumentException, IOException {
        this.G = swfFileInfo.getAs3Packages();
        Paragraph paragraph = new Paragraph(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Renaming_Details"), FontFactory.getFont((String)"Times-Roman", (float)16.0f, (int)0, (Color)Color.BLACK));
        this.A.add((Element)paragraph);
        for (int i = 0; i < this.G.length; ++i) {
            this.A(this.G[i], i);
        }
    }

    private void A(Identifier identifier, int n) throws DocumentException, BadElementException, MalformedURLException, IOException {
        if (identifier == null) {
            return;
        }
        String string = ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Package_Name");
        string = !identifier.getName().equals("") ? string + identifier.getName() + ", " : string + ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Package_is_UnNamed");
        string = identifier.isRenameSelectedValue() && !identifier.getName().equals("") ? string + ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("renamed") : string + ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("not_renamed");
        Paragraph paragraph = new Paragraph(string, FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)0, (Color)Color.RED));
        paragraph.setSpacingAfter(5.0f);
        this.C = new Chapter(paragraph, n + 1);
        this.C.setNumberDepth(2);
        this.C.setTriggerNewPage(false);
        this.A.add((Element)this.C);
        Identifier[] identifierArray = identifier.getMembers();
        for (int i = 0; i < identifierArray.length; ++i) {
            this.B(identifierArray[i]);
        }
    }

    private void B(Identifier identifier) throws DocumentException, IOException {
        String[] stringArray;
        int n;
        PDFTable pDFTable;
        Paragraph paragraph;
        Object object;
        Paragraph paragraph2 = new Paragraph("", FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)0, (Color)Color.BLACK));
        this.H = this.C.addSection(paragraph2);
        this.H.setIndentationLeft(15.0f);
        Phrase phrase = new Phrase();
        Phrase phrase2 = new Phrase(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Class_Name") + " ", FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)0, (Color)Color.BLUE));
        Phrase phrase3 = identifier.isRenameSelectedValue() && !identifier.getName().equals("") ? new Phrase(identifier.getName() + " " + ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("renamed"), FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)0, (Color)Color.BLACK)) : new Phrase(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("not_renamed"), FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)0, (Color)Color.BLACK));
        ArrayList<Identifier> arrayList = new ArrayList<Identifier>();
        ArrayList<Identifier> arrayList2 = new ArrayList<Identifier>();
        this.A(identifier, arrayList, arrayList2);
        double d2 = 0.0;
        if (arrayList.size() + arrayList2.size() != 0) {
            d2 = (double)arrayList.size() / (double)(arrayList.size() + arrayList2.size());
        }
        if (arrayList.size() + arrayList2.size() > 0 && d2 > 0.0) {
            phrase = new Phrase(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Renaming_Percentage") + " %" + Math.round(d2 * 100.0), FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)0, (Color)Color.BLACK));
        }
        paragraph2.add((Object)phrase2);
        paragraph2.add((Object)phrase3);
        paragraph2.add((Object)phrase);
        paragraph2.setSpacingAfter(10.0f);
        if (arrayList.size() > 0) {
            this.A(d2);
        }
        if (arrayList.size() + arrayList2.size() != 0) {
            if (arrayList.size() == 0) {
                object = new Phrase(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Class_") + " " + identifier.getName() + " " + ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("_has_no_renamed_identifiers"), FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)0, (Color)Color.BLACK));
                paragraph2.add(object);
            }
        } else {
            object = new Phrase(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Class_") + " " + identifier.getName() + " " + ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("_has_no_identifiers"), FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)0, (Color)Color.BLACK));
            paragraph2.add(object);
        }
        this.A.add((Element)this.H);
        object = new float[]{2.0f, 0.5f, 0.5f};
        if (arrayList.size() > 0) {
            paragraph = new Paragraph("The following identifiers have been renamed:", FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)2, (Color)Color.RED));
            paragraph.setSpacingAfter(5.0f);
            this.A.add((Element)Chunk.NEWLINE);
            this.A.add((Element)Chunk.NEWLINE);
            this.A.add((Element)paragraph);
            pDFTable = new PDFTable(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Name"), ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Type"), ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Modifier")}, (float[])object);
            for (n = 0; n < arrayList.size(); ++n) {
                stringArray = new String[]{arrayList.get(n).getName().toLowerCase(), arrayList.get(n).getType().substring(arrayList.get(n).getType().indexOf(" ") + 1, arrayList.get(n).getType().length()).toLowerCase(), arrayList.get(n).getType().substring(0, arrayList.get(n).getType().indexOf(" "))};
                pDFTable.addRow(stringArray);
            }
            this.A(pDFTable, 85, false);
        }
        if (arrayList2.size() > 0) {
            paragraph = new Paragraph(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("The_following_identifiers_have_not_been_renamed"), FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)2, (Color)Color.RED));
            paragraph.setSpacingAfter(5.0f);
            this.A.add((Element)paragraph);
            pDFTable = new PDFTable(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Name"), ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Type"), ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Modifier")}, (float[])object);
            for (n = 0; n < arrayList2.size(); ++n) {
                stringArray = new String[]{arrayList2.get(n).getName().toLowerCase(), arrayList2.get(n).getType().substring(arrayList2.get(n).getType().indexOf(" ") + 1, arrayList2.get(n).getType().length()).toLowerCase(), arrayList2.get(n).getType().substring(0, arrayList2.get(n).getType().indexOf(" "))};
                pDFTable.addRow(stringArray);
            }
            this.A(pDFTable, 85, false);
        }
    }

    private void A(PDFTable pDFTable, int n, boolean bl) throws DocumentException {
        int n2;
        PdfPTable pdfPTable = new PdfPTable(pDFTable.getColumnCount());
        for (n2 = 0; n2 < pDFTable.getHeader().length; ++n2) {
            PdfPCell pdfPCell = new PdfPCell((Phrase)new Paragraph(pDFTable.getHeader()[n2], FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)1, (Color)Color.BLACK)));
            pdfPCell.setBackgroundColor(Color.LIGHT_GRAY);
            this.A(pdfPCell);
            pdfPTable.addCell(pdfPCell);
        }
        for (n2 = 0; n2 < pDFTable.getRowCount(); ++n2) {
            for (int i = 0; i < pDFTable.getColumnCount(); ++i) {
                PdfPCell pdfPCell = new PdfPCell((Phrase)new Paragraph(pDFTable.getCellAt(n2, i), FontFactory.getFont((String)"Times-Roman", (float)10.0f, (int)0, (Color)Color.BLACK)));
                this.A(pdfPCell);
                if (bl && i > 0) {
                    pdfPCell.setHorizontalAlignment(2);
                }
                pdfPTable.addCell(pdfPCell);
            }
        }
        pdfPTable.setWidths(pDFTable.getWidths());
        pdfPTable.setHorizontalAlignment(0);
        pdfPTable.setWidthPercentage((float)n);
        pdfPTable.setSpacingBefore(0.0f);
        pdfPTable.setSpacingAfter(5.0f);
        pdfPTable.setSplitRows(false);
        this.A.add((Element)pdfPTable);
        this.A.add((Element)Chunk.NEWLINE);
    }

    private void A(Identifier identifier, ArrayList<Identifier> arrayList, ArrayList<Identifier> arrayList2) {
        for (int i = 0; i < identifier.getMembers().length; ++i) {
            Identifier identifier2 = identifier.getMembers()[i];
            if (identifier2.isRenameSelectedValue()) {
                arrayList.add(identifier2);
                continue;
            }
            arrayList2.add(identifier2);
        }
    }

    private void A(SwfFileInfo swfFileInfo, ArrayList<Identifier> arrayList) {
        for (int i = 0; i < swfFileInfo.getAs3Packages().length; ++i) {
            Identifier identifier = swfFileInfo.getAs3Packages()[i];
            for (int j = 0; j < identifier.getMembers().length; ++j) {
                Identifier identifier2 = identifier.getMembers()[j];
                for (int k = 0; k < identifier2.getMembers().length; ++k) {
                    Identifier identifier3 = identifier2.getMembers()[k];
                    if (!identifier3.getType().contains("Public Function") || identifier3.getCfoPercentage() == null && identifier3.getSlrEnabled() == null && identifier3.getDcwIntensity() == null) continue;
                    arrayList.add(identifier3);
                }
            }
        }
    }

    private void A(PdfPCell pdfPCell) {
        pdfPCell.setNoWrap(false);
        pdfPCell.setVerticalAlignment(1);
        pdfPCell.setPaddingLeft(3.0f);
        pdfPCell.setPaddingBottom(8.0f);
        pdfPCell.setBorderColor(Color.GRAY);
    }

    private void A(double d2) throws BadElementException, IOException, DocumentException {
        Image image = null;
        int n = (int)Math.round(d2 * 100.0);
        int n2 = n % 10;
        if (n2 > 5) {
            n += 10 - n2;
        }
        if (n2 == 5) {
            n += 5;
        }
        if (n2 < 5) {
            n -= n2;
        }
        switch (n) {
            case 0: {
                image = Image.getInstance((URL)this.getClass().getResource("images/image00.jpg"));
                break;
            }
            case 10: {
                image = Image.getInstance((URL)this.getClass().getResource("images/image10.jpg"));
                break;
            }
            case 20: {
                image = Image.getInstance((URL)this.getClass().getResource("images/image20.jpg"));
                break;
            }
            case 30: {
                image = Image.getInstance((URL)this.getClass().getResource("images/image30.jpg"));
                break;
            }
            case 40: {
                image = Image.getInstance((URL)this.getClass().getResource("images/image40.jpg"));
                break;
            }
            case 50: {
                image = Image.getInstance((URL)this.getClass().getResource("images/image50.jpg"));
                break;
            }
            case 60: {
                image = Image.getInstance((URL)this.getClass().getResource("images/image60.jpg"));
                break;
            }
            case 70: {
                image = Image.getInstance((URL)this.getClass().getResource("images/image70.jpg"));
                break;
            }
            case 80: {
                image = Image.getInstance((URL)this.getClass().getResource("images/image80.jpg"));
                break;
            }
            case 90: {
                image = Image.getInstance((URL)this.getClass().getResource("images/image90.jpg"));
                break;
            }
            case 100: {
                image = Image.getInstance((URL)this.getClass().getResource("images/image100.jpg"));
            }
        }
        image.scalePercent(25.0f, 25.0f);
        image.setAlignment(14);
        this.A.add((Element)image);
    }

    private void B() throws DocumentException {
        PDFTable pDFTable = new PDFTable(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Name_of_Action"), ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Setting")}, new float[]{2.0f, 1.0f});
        Paragraph paragraph = new Paragraph(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Table_of_Actions"), FontFactory.getFont((String)"Times-Roman", (float)14.0f, (int)0, (Color)Color.RED));
        paragraph.setSpacingAfter(5.0f);
        this.A.add((Element)paragraph);
        switch (this.D.getRenamingLevel()) {
            case 0: {
                pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Renaming_Level"), ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Safe")});
                break;
            }
            case 6: {
                pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Renaming_Level"), ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Normal")});
                break;
            }
            case 10: {
                pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Renaming_Level"), ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Rename_Everything")});
            }
        }
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Aggressive_Renaming"), this.D.isAggressiveRenaming() ? ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Enabled") : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Disabled")});
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Use_Actionscript_keywords"), this.D.isUseAsKeywords() ? ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Enabled") : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Disabled")});
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Rename_Protect_namespaces"), this.D.isRenameProtectedNamespaces() ? ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Enabled") : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Disabled")});
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Generate_Map_File"), this.D.isGenerateMapFile() ? ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Enabled") : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Disabled")});
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Statement_Level_Obfuscation"), this.D.isStatementLevelObfuscation() ? ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Enabled") : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Disabled")});
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Control_Flow_Obfuscation_Level"), this.D.getControlFlowObfuscation() > 0 ? "%" + Integer.toString(this.D.getControlFlowObfuscation()) : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Disabled")});
        String[] stringArray = new String[2];
        stringArray[0] = ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Dynamic_Code_Wrapping_Intensity");
        stringArray[1] = this.D.getCodeWrapIntensity() > 0 ? (this.D.getCodeWrapIntensity() == 1 ? ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Minimum") : (this.D.getCodeWrapIntensity() == 2 ? ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Medium") : (this.D.getCodeWrapIntensity() == 3 ? ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Maximum") : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Disabled")))) : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Disabled");
        pDFTable.addRow(stringArray);
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Break_Function_Call"), this.D.isFunctionCallBreaking() ? ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Enabled") : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Disabled")});
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Domain_Locking"), this.D.getSelectedDomains() != null && this.D.getSelectedDomains().length > 0 ? ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Enabled") : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Disabled")});
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Prevent_Local_Execution"), this.D.isPreventLocalExecution() ? ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Enabled") : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Disabled")});
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Perform_Code_Optimization"), this.D.isPerformOptimization() ? ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Enabled") : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Disabled")});
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Remove_Metadata"), this.D.isRemoveMetadata() ? ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Enabled") : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Disabled")});
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Force_File_Compression"), this.D.isForceCompression() ? ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Enabled") : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Disabled")});
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Remove_Dead_Code"), this.D.isRemoveDeadCode() ? ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Enabled") : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Disabled")});
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Super_Compression"), this.D.isKZipCompression() ? ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Enabled") : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Disabled")});
        this.A(pDFTable, 90, false);
    }

    private void A(SwfFileInfo swfFileInfo) throws DocumentException {
        ArrayList<Identifier> arrayList = new ArrayList<Identifier>();
        this.A(swfFileInfo, arrayList);
        if (arrayList.size() == 0) {
            return;
        }
        PDFTable pDFTable = new PDFTable(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Name"), ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("SLR_enabled"), ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("CFO_percentage"), ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Dynamic_Code_Wrapping_Intensity")}, new float[]{2.0f, 1.0f, 1.0f, 1.0f});
        Paragraph paragraph = new Paragraph(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Advanced_Code_Transformation"), FontFactory.getFont((String)"Times-Roman", (float)14.0f, (int)0, (Color)Color.RED));
        paragraph.setSpacingAfter(5.0f);
        this.A.add((Element)paragraph);
        for (int i = 0; i < arrayList.size(); ++i) {
            String[] stringArray = new String[4];
            stringArray[0] = arrayList.get(i).getQName() != null ? arrayList.get(i).getQName().substring(arrayList.get(i).getQName().lastIndexOf(".") + 1) : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Not_specefied");
            stringArray[1] = arrayList.get(i).getSlrEnabled() != null ? ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Enabled") : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Disabled");
            stringArray[2] = arrayList.get(i).getCfoPercentage() != null ? arrayList.get(i).getCfoPercentage().toString() : ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Off");
            if (arrayList.get(i).getDcwIntensity() != null) {
                int n = arrayList.get(i).getDcwIntensity();
                switch (n) {
                    case 0: {
                        stringArray[3] = ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Off");
                        break;
                    }
                    case 1: {
                        stringArray[3] = ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Minimum");
                        break;
                    }
                    case 2: {
                        stringArray[3] = ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Medium");
                        break;
                    }
                    case 3: {
                        stringArray[3] = ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Maximum");
                    }
                }
            } else {
                stringArray[3] = ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Off");
            }
            pDFTable.addRow(stringArray);
        }
        this.A(pDFTable, 95, false);
    }

    private void C() throws DocumentException {
        if (this.D.getSelectedDomains().length == 0) {
            return;
        }
        Paragraph paragraph = new Paragraph(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Selected_Domains"), FontFactory.getFont((String)"Times-Roman", (float)14.0f, (int)0, (Color)Color.RED));
        this.A.add((Element)paragraph);
        for (int i = 0; i < this.D.getSelectedDomains().length; ++i) {
            paragraph = new Paragraph("- " + this.D.getSelectedDomains()[i] + "\n", FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)0, (Color)Color.BLACK));
            paragraph.setIndentationLeft(5.0f);
            this.A.add((Element)paragraph);
        }
        this.A.add((Element)Chunk.NEWLINE);
    }

    private void B(int n) throws DocumentException {
        PDFTable pDFTable = new PDFTable(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("String"), ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Occurences")}, new float[]{3.0f, 1.0f});
        EncryptionString[] encryptionStringArray = this.D.getSwfFiles()[n].getEncryptionLiteralStrings();
        for (int i = 0; i < encryptionStringArray.length; ++i) {
            if (!encryptionStringArray[i].isEncrypted()) continue;
            pDFTable.addRow(new String[]{encryptionStringArray[i].getStringValue(), Integer.toString(encryptionStringArray[i].getOccurrences())});
        }
        if (pDFTable.getRowCount() > 0) {
            Paragraph paragraph = new Paragraph(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Litral_String_Encryption"), FontFactory.getFont((String)"Times-Roman", (float)14.0f, (int)0, (Color)Color.RED));
            paragraph.setSpacingAfter(5.0f);
            this.A.add((Element)paragraph);
            this.A(pDFTable, 55, true);
        }
    }

    private void A(int n) throws DocumentException {
        int n2;
        int n3;
        int n4;
        PDFTable pDFTable = new PDFTable(new String[]{"", ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Occurences")}, new float[]{2.0f, 1.0f});
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Packages"), Integer.toString(this.D.getSwfFiles()[n].getAs3Packages().length)});
        int n5 = 0;
        for (n4 = 0; n4 < this.D.getSwfFiles()[n].getAs3Packages().length; ++n4) {
            n5 += this.D.getSwfFiles()[n].getAs3Packages()[n4].getMembers().length;
        }
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Classes"), Integer.toString(n5)});
        n4 = 0;
        for (n3 = 0; n3 < this.D.getSwfFiles()[n].getAs3Packages().length; ++n3) {
            for (n2 = 0; n2 < this.D.getSwfFiles()[n].getAs3Packages()[n3].getMembers().length; ++n2) {
                n4 += this.D.getSwfFiles()[n].getAs3Packages()[n3].getMembers()[n2].getMembers().length;
            }
        }
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Class_Members"), Integer.toString(n4)});
        n3 = 0;
        for (n2 = 0; n2 < this.D.getSwfFiles()[n].getMovieClips().length; ++n2) {
            n3 += this.D.getSwfFiles()[n].getMovieClips()[n2].getLabels().length;
        }
        pDFTable.addRow(new String[]{ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Labels"), Integer.toString(n3)});
        Paragraph paragraph = new Paragraph(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Statistics"), FontFactory.getFont((String)"Times-Roman", (float)14.0f, (int)0, (Color)Color.RED));
        paragraph.setSpacingAfter(5.0f);
        this.A.add((Element)paragraph);
        this.A(pDFTable, 50, true);
    }

    private void D(int n) throws DocumentException, IOException {
        Point point;
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.D.getSwfFiles()[n].getAs3Packages().length; ++n2) {
            Identifier identifier = this.D.getSwfFiles()[n].getAs3Packages()[n2];
            point = this.A(identifier);
            n4 += point.x;
            n3 += point.y;
        }
        for (n2 = 0; n2 < this.D.getSwfFiles()[n].getMovieClips().length; ++n2) {
            for (int i = 0; i < this.D.getSwfFiles()[n].getMovieClips()[n2].getLabels().length; ++i) {
                if (this.D.getSwfFiles()[n].getMovieClips()[n2].getLabels()[i].isRenameSelectedValue()) {
                    ++n4;
                }
                ++n3;
            }
        }
        double d2 = (double)n4 / (double)n3;
        point = new Paragraph(ResourceBundle.getBundle("secureSWF/components/resources/Pdf").getString("Total_Percentage_of_Renaming_in_this_File_is") + " " + this.D.getSwfFiles()[n].getFileName() + ": " + "%" + Math.round(d2 * 100.0), FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)0, (Color)Color.BLACK));
        this.A(d2);
        this.A.add((Element)Chunk.NEWLINE);
        this.A.add((Element)point);
        this.A.add((Element)Chunk.NEWLINE);
        this.A.add((Element)Chunk.NEWLINE);
        this.A.add((Element)Chunk.NEWLINE);
    }

    private Point A(Identifier identifier) {
        int n = identifier.isRenameSelectedValue() ? 1 : 0;
        int n2 = 1;
        if (identifier.getMembers() != null && identifier.getMembers().length > 0) {
            for (int i = 0; i < identifier.getMembers().length; ++i) {
                Identifier identifier2 = identifier.getMembers()[i];
                Point point = this.A(identifier2);
                n += point.x;
                n2 += point.y;
            }
        }
        return new Point(n, n2);
    }
}

