/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.dnd.DropTarget;
import java.awt.image.BufferedImage;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import sun.awt.CausedFocusEvent;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;
import sun.java2d.pipe.Region;

public class WFileDialogPeer
extends WWindowPeer
implements FileDialogPeer {
    private WComponentPeer parent;
    private FilenameFilter fileFilter;
    private Vector<WWindowPeer> blockedWindows = new Vector();

    private static native void setFilterString(String var0);

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.fileFilter = filenameFilter;
    }

    boolean checkFilenameFilter(String string) {
        FileDialog fileDialog = (FileDialog)this.target;
        if (this.fileFilter == null) {
            return true;
        }
        File file = new File(string);
        return this.fileFilter.accept(new File(file.getParent()), file.getName());
    }

    WFileDialogPeer(FileDialog fileDialog) {
        super(fileDialog);
    }

    void create(WComponentPeer wComponentPeer) {
        this.parent = wComponentPeer;
    }

    protected void checkCreation() {
    }

    void initialize() {
    }

    private native void _dispose();

    protected void disposeImpl() {
        WToolkit.targetDisposedPeer(this.target, this);
        this._dispose();
    }

    private native void _show();

    private native void _hide();

    public void show() {
        new Thread(new Runnable(){

            public void run() {
                WFileDialogPeer.this._show();
            }
        }).start();
    }

    public void hide() {
        this._hide();
    }

    void setHWnd(long l) {
        if (this.hwnd == l) {
            return;
        }
        this.hwnd = l;
        for (WWindowPeer wWindowPeer : this.blockedWindows) {
            if (l != 0L) {
                wWindowPeer.modalDisable((Dialog)this.target, l);
                continue;
            }
            wWindowPeer.modalEnable((Dialog)this.target);
        }
    }

    void handleSelected(final String string) {
        final FileDialog fileDialog = (FileDialog)this.target;
        WToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(){

            public void run() {
                String string2;
                int n = string.lastIndexOf(File.separatorChar);
                if (n == -1) {
                    string2 = "." + File.separator;
                    fileDialog.setFile(string);
                } else {
                    string2 = string.substring(0, n + 1);
                    fileDialog.setFile(string.substring(n + 1));
                }
                fileDialog.setDirectory(string2);
                fileDialog.hide();
            }
        });
    }

    void handleCancel() {
        final FileDialog fileDialog = (FileDialog)this.target;
        WToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(){

            public void run() {
                fileDialog.setFile(null);
                fileDialog.hide();
            }
        });
    }

    void blockWindow(WWindowPeer wWindowPeer) {
        this.blockedWindows.add(wWindowPeer);
        if (this.hwnd != 0L) {
            wWindowPeer.modalDisable((Dialog)this.target, this.hwnd);
        }
    }

    void unblockWindow(WWindowPeer wWindowPeer) {
        this.blockedWindows.remove(wWindowPeer);
        if (this.hwnd != 0L) {
            wWindowPeer.modalEnable((Dialog)this.target);
        }
    }

    public native void toFront();

    public native void toBack();

    public void setAlwaysOnTop(boolean bl) {
    }

    public void setDirectory(String string) {
    }

    public void setFile(String string) {
    }

    public void setTitle(String string) {
    }

    public void setResizable(boolean bl) {
    }

    public void enable() {
    }

    public void disable() {
    }

    public void reshape(int n, int n2, int n3, int n4) {
    }

    public boolean handleEvent(Event event) {
        return false;
    }

    public void setForeground(Color color) {
    }

    public void setBackground(Color color) {
    }

    public void setFont(Font font) {
    }

    public void updateMinimumSize() {
    }

    public void updateIconImages() {
    }

    public boolean requestFocus(boolean bl, boolean bl2) {
        return false;
    }

    public boolean requestFocus(Component component, boolean bl, boolean bl2, long l, CausedFocusEvent.Cause cause) {
        return false;
    }

    void start() {
    }

    public void beginValidate() {
    }

    public void endValidate() {
    }

    void invalidate(int n, int n2, int n3, int n4) {
    }

    public void addDropTarget(DropTarget dropTarget) {
    }

    public void removeDropTarget(DropTarget dropTarget) {
    }

    public void updateFocusableWindowState() {
    }

    private static native void initIDs();

    public void restack() {
    }

    public boolean isRestackSupported() {
        return false;
    }

    public void applyShape(Region region) {
    }

    public void setOpacity(float f) {
    }

    public void setOpaque(boolean bl) {
    }

    public void updateWindow(BufferedImage bufferedImage) {
    }

    static {
        WFileDialogPeer.initIDs();
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle("sun.awt.windows.awtLocalization");
                    return resourceBundle.getString("allFiles");
                }
                catch (MissingResourceException missingResourceException) {
                    return "All Files";
                }
            }
        });
        WFileDialogPeer.setFilterString(string);
    }
}

