/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.PaintEvent;
import java.beans.Beans;
import java.lang.reflect.Constructor;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ProxyActions;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.application.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ProxyActions(value={"cut", "copy", "paste", "delete"})
public abstract class Application
extends AbstractBean {
    private static final Logger \u00c7 = Logger.getLogger(Application.class.getName());
    private static Application \u00c6 = null;
    private final List<ExitListener> \u00c9 = new CopyOnWriteArrayList<ExitListener>();
    private final ApplicationContext \u00c8 = new ApplicationContext();

    protected Application() {
    }

    public static synchronized <T extends Application> void launch(final Class<T> clazz, final String[] stringArray) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    \u00c6 = (Application)Application.B(clazz);
                    \u00c6.initialize(stringArray);
                    \u00c6.startup();
                    \u00c6._();
                }
                catch (Exception exception) {
                    String string = String.format("Application %s failed to launch", clazz);
                    \u00c7.log(Level.SEVERE, string, exception);
                    throw new Error(string, exception);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    static <T extends Application> T B(Class<T> clazz) throws Exception {
        Constructor<T> constructor;
        if (!Beans.isDesignTime()) {
            try {
                System.setProperty("java.net.useSystemProxies", "true");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (!(constructor = clazz.getDeclaredConstructor(new Class[0])).isAccessible()) {
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        Application application = (Application)constructor.newInstance(new Object[0]);
        ApplicationContext applicationContext = application.getContext();
        applicationContext.setApplicationClass(clazz);
        applicationContext.A(application);
        ResourceMap resourceMap = applicationContext.getResourceMap();
        resourceMap.putResource("platform", Application.W());
        if (!Beans.isDesignTime()) {
            String string = "Application.lookAndFeel";
            String string2 = resourceMap.getString(string, new Object[0]);
            String string3 = string2 == null ? "system" : string2;
            try {
                if (string3.equalsIgnoreCase("system")) {
                    String string4 = UIManager.getSystemLookAndFeelClassName();
                    UIManager.setLookAndFeel(string4);
                } else if (!string3.equalsIgnoreCase("default")) {
                    UIManager.setLookAndFeel(string3);
                }
            }
            catch (Exception exception) {
                String string5 = "Couldn't set LookandFeel " + string + " = \"" + string2 + "\"";
                \u00c7.log(Level.WARNING, string5, exception);
            }
        }
        return (T)application;
    }

    private static String W() {
        String string = "default";
        try {
            String string2 = System.getProperty("os.name");
            if (string2 != null && string2.toLowerCase().startsWith("mac os x")) {
                string = "osx";
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string;
    }

    void _() {
        new _A().execute();
    }

    protected void initialize(String[] stringArray) {
    }

    protected abstract void startup();

    protected void ready() {
    }

    protected void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Z() {
        boolean bl = false;
        JPanel jPanel = new JPanel();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while (!bl) {
            _B _B2 = new _B(jPanel);
            eventQueue.postEvent(_B2);
            _B _B3 = _B2;
            synchronized (_B3) {
                while (!_B2.A()) {
                    try {
                        _B2.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                bl = _B2.B();
            }
        }
    }

    public final void exit() {
        this.exit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(EventObject eventObject) {
        for (ExitListener exitListener : this.\u00c9) {
            if (exitListener.canExit(eventObject)) continue;
            return;
        }
        try {
            for (ExitListener exitListener : this.\u00c9) {
                try {
                    exitListener.willExit(eventObject);
                }
                catch (Exception exception) {
                    \u00c7.log(Level.WARNING, "ExitListener.willExit() failed", exception);
                }
            }
            this.shutdown();
        }
        catch (Exception exception) {
            \u00c7.log(Level.WARNING, "unexpected error in Application.shutdown()", exception);
        }
        finally {
            this.end();
        }
    }

    protected void end() {
        Runtime.getRuntime().exit(0);
    }

    public void addExitListener(ExitListener exitListener) {
        this.\u00c9.add(exitListener);
    }

    public void removeExitListener(ExitListener exitListener) {
        this.\u00c9.remove(exitListener);
    }

    public ExitListener[] getExitListeners() {
        int n = this.\u00c9.size();
        return this.\u00c9.toArray(new ExitListener[n]);
    }

    @Action
    public void quit(ActionEvent actionEvent) {
        this.exit(actionEvent);
    }

    public final ApplicationContext getContext() {
        return this.\u00c8;
    }

    public static synchronized <T extends Application> T getInstance(Class<T> clazz) {
        if (\u00c6 == null) {
            try {
                \u00c6 = Application.B(clazz);
            }
            catch (Exception exception) {
                String string = String.format("Couldn't construct %s", clazz);
                throw new Error(string, exception);
            }
        }
        return (T)((Application)clazz.cast(\u00c6));
    }

    public static synchronized Application getInstance() {
        if (\u00c6 == null) {
            \u00c6 = new _C();
        }
        return \u00c6;
    }

    public void show(View view) {
        Window window = (Window)view.getRootPane().getParent();
        if (window != null) {
            window.pack();
            window.setVisible(true);
        }
    }

    public void hide(View view) {
        view.getRootPane().getParent().setVisible(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _A
    extends Task<Void, Void> {
        _A() {
            super(Application.this);
        }

        protected Void E() {
            Application.this.Z();
            return null;
        }

        @Override
        protected void finished() {
            Application.this.ready();
        }
    }

    public static interface ExitListener
    extends EventListener {
        public boolean canExit(EventObject var1);

        public void willExit(EventObject var1);
    }

    private static class _C
    extends Application {
        protected _C() {
            ApplicationContext applicationContext = this.getContext();
            applicationContext.setApplicationClass(this.getClass());
            applicationContext.A(this);
            ResourceMap resourceMap = applicationContext.getResourceMap();
            resourceMap.putResource("platform", Application.W());
        }

        protected void startup() {
        }
    }

    private static class _B
    extends PaintEvent
    implements ActiveEvent {
        private boolean B = false;
        private boolean A = false;

        _B(Component component) {
            super(component, 801, null);
        }

        synchronized boolean A() {
            return this.B;
        }

        synchronized boolean B() {
            return this.A;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatch() {
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            _B _B2 = this;
            synchronized (_B2) {
                this.A = eventQueue.peekEvent() == null;
                this.B = true;
                this.notifyAll();
            }
        }
    }
}

