/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdesktop.application.ResourceMap;

public abstract class ResourceConverter {
    protected final Class type;
    private static ResourceConverter[] B = new ResourceConverter[]{new _J("true", "on", "yes"), new _K(), new _F(), new _I(), new _E(), new _D(), new _C(), new _G(), new _L(), new _H()};
    private static List<ResourceConverter> A = new ArrayList<ResourceConverter>(Arrays.asList(B));

    public abstract Object parseString(String var1, ResourceMap var2) throws ResourceConverterException;

    public String toString(Object object) {
        return object == null ? "null" : object.toString();
    }

    protected ResourceConverter(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("null type");
        }
        this.type = clazz;
    }

    private ResourceConverter() {
        this.type = null;
    }

    public boolean supportsType(Class clazz) {
        return this.type.equals(clazz);
    }

    public static void register(ResourceConverter resourceConverter) {
        if (resourceConverter == null) {
            throw new IllegalArgumentException("null resourceConverter");
        }
        A.add(resourceConverter);
    }

    public static ResourceConverter forType(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("null type");
        }
        for (ResourceConverter resourceConverter : A) {
            if (!resourceConverter.supportsType(clazz)) continue;
            return resourceConverter;
        }
        return null;
    }

    private static class _J
    extends ResourceConverter {
        private final String[] D;

        _J(String ... stringArray) {
            super(Boolean.class);
            this.D = stringArray;
        }

        public Object parseString(String string, ResourceMap resourceMap) {
            string = string.trim();
            for (String string2 : this.D) {
                if (!string.equalsIgnoreCase(string2)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public boolean supportsType(Class clazz) {
            return clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE);
        }
    }

    private static class _G
    extends _A {
        _G() {
            super(Byte.class, Byte.TYPE);
        }

        protected Number A(String string, int n) throws NumberFormatException {
            return n == -1 ? Byte.decode(string) : Byte.parseByte(string, n);
        }
    }

    private static class _E
    extends _B {
        _E() {
            super(Double.class, Double.TYPE);
        }

        protected Number A(String string) throws NumberFormatException {
            return Double.parseDouble(string);
        }
    }

    private static class _I
    extends _B {
        _I() {
            super(Float.class, Float.TYPE);
        }

        protected Number A(String string) throws NumberFormatException {
            return Float.valueOf(Float.parseFloat(string));
        }
    }

    private static abstract class _A
    extends ResourceConverter {
        private final Class E;

        _A(Class clazz, Class clazz2) {
            super(clazz);
            this.E = clazz2;
        }

        protected abstract Number A(String var1, int var2) throws NumberFormatException;

        public Object parseString(String string, ResourceMap resourceMap) throws ResourceConverterException {
            try {
                String[] stringArray = string.split("&");
                int n = stringArray.length == 2 ? Integer.parseInt(stringArray[1]) : -1;
                return this.A(stringArray[0], n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ResourceConverterException("invalid " + this.type.getSimpleName(), string, numberFormatException);
            }
        }

        public boolean supportsType(Class clazz) {
            return clazz.equals(this.type) || clazz.equals(this.E);
        }
    }

    private static class _K
    extends _A {
        _K() {
            super(Integer.class, Integer.TYPE);
        }

        protected Number A(String string, int n) throws NumberFormatException {
            return n == -1 ? Integer.decode(string) : Integer.parseInt(string, n);
        }
    }

    private static class _D
    extends _A {
        _D() {
            super(Long.class, Long.TYPE);
        }

        protected Number A(String string, int n) throws NumberFormatException {
            return n == -1 ? Long.decode(string) : Long.parseLong(string, n);
        }
    }

    private static class _F
    extends ResourceConverter {
        _F() {
            super(MessageFormat.class);
        }

        public Object parseString(String string, ResourceMap resourceMap) {
            return new MessageFormat(string);
        }
    }

    private static abstract class _B
    extends ResourceConverter {
        private final Class C;

        _B(Class clazz, Class clazz2) {
            super(clazz);
            this.C = clazz2;
        }

        protected abstract Number A(String var1) throws NumberFormatException;

        public Object parseString(String string, ResourceMap resourceMap) throws ResourceConverterException {
            try {
                return this.A(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ResourceConverterException("invalid " + this.type.getSimpleName(), string, numberFormatException);
            }
        }

        public boolean supportsType(Class clazz) {
            return clazz.equals(this.type) || clazz.equals(this.C);
        }
    }

    public static class ResourceConverterException
    extends Exception {
        private final String A;

        private String A(String string) {
            int n = string.length();
            return n < 128 ? string : string.substring(0, 128) + "...[" + (n - 128) + " more characters]";
        }

        public ResourceConverterException(String string, String string2, Throwable throwable) {
            super(string, throwable);
            this.A = this.A(string2);
        }

        public ResourceConverterException(String string, String string2) {
            super(string);
            this.A = this.A(string2);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(" string: \"");
            stringBuffer.append(this.A);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
    }

    private static class _C
    extends _A {
        _C() {
            super(Short.class, Short.TYPE);
        }

        protected Number A(String string, int n) throws NumberFormatException {
            return n == -1 ? Short.decode(string) : Short.parseShort(string, n);
        }
    }

    private static class _H
    extends ResourceConverter {
        _H() {
            super(URI.class);
        }

        public Object parseString(String string, ResourceMap resourceMap) throws ResourceConverterException {
            try {
                return new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ResourceConverterException("invalid URI", string, uRISyntaxException);
            }
        }
    }

    private static class _L
    extends ResourceConverter {
        _L() {
            super(URL.class);
        }

        public Object parseString(String string, ResourceMap resourceMap) throws ResourceConverterException {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ResourceConverterException("invalid URL", string, malformedURLException);
            }
        }
    }
}

