/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.A;
import org.jdesktop.application.Resource;
import org.jdesktop.application.ResourceConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMap {
    private static Logger I;
    private static final Object H;
    private final ClassLoader B;
    private final ResourceMap F;
    private final List<String> J;
    private final String C;
    private Map<String, Object> A = null;
    private Locale E = Locale.getDefault();
    private Set<String> D = null;
    private boolean G = false;

    public ResourceMap(ResourceMap resourceMap, ClassLoader classLoader, List<String> list) {
        if (classLoader == null) {
            throw new IllegalArgumentException("null ClassLoader");
        }
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("no bundle specified");
        }
        for (String object : list) {
            if (object != null && object.length() != 0) continue;
            throw new IllegalArgumentException("invalid bundleName: \"" + object + "\"");
        }
        String string = this.A(list.get(0));
        for (String string2 : list) {
            if (string.equals(this.A(string2))) continue;
            throw new IllegalArgumentException("bundles not colocated: \"" + string2 + "\" != \"" + (String)string + "\"");
        }
        this.F = resourceMap;
        this.B = classLoader;
        this.J = Collections.unmodifiableList(new ArrayList<String>(list));
        this.C = string.replace(".", "/") + "/";
    }

    private String A(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? "" : string.substring(0, n);
    }

    public ResourceMap(ResourceMap resourceMap, ClassLoader classLoader, String ... stringArray) {
        this(resourceMap, classLoader, Arrays.asList(stringArray));
    }

    public ResourceMap getParent() {
        return this.F;
    }

    public List<String> getBundleNames() {
        return this.J;
    }

    public ClassLoader getClassLoader() {
        return this.B;
    }

    public String getResourcesDir() {
        return this.C;
    }

    private synchronized Map<String, Object> A() {
        Locale locale = Locale.getDefault();
        if (this.E != locale) {
            this.G = false;
            this.E = locale;
        }
        if (!this.G) {
            ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
            for (int i = this.J.size() - 1; i >= 0; --i) {
                try {
                    String string = this.J.get(i);
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(string, this.E, this.B);
                    Enumeration<String> enumeration = resourceBundle.getKeys();
                    while (enumeration.hasMoreElements()) {
                        String string2 = enumeration.nextElement();
                        concurrentHashMap.put(string2, resourceBundle.getObject(string2));
                    }
                    continue;
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            this.A = concurrentHashMap;
            this.G = true;
        }
        return this.A;
    }

    private void C(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null key");
        }
    }

    private synchronized Set<String> B() {
        if (this.D == null) {
            HashSet<String> hashSet = new HashSet<String>(this.getResourceKeySet());
            ResourceMap resourceMap = this.getParent();
            if (resourceMap != null) {
                hashSet.addAll(resourceMap.keySet());
            }
            this.D = Collections.unmodifiableSet(hashSet);
        }
        return this.D;
    }

    public Set<String> keySet() {
        return this.B();
    }

    public boolean containsKey(String string) {
        this.C(string);
        if (this.containsResourceKey(string)) {
            return true;
        }
        ResourceMap resourceMap = this.getParent();
        return resourceMap != null ? resourceMap.containsKey(string) : false;
    }

    protected Set<String> getResourceKeySet() {
        Map<String, Object> map = this.A();
        if (map == null) {
            return Collections.emptySet();
        }
        return map.keySet();
    }

    protected boolean containsResourceKey(String string) {
        this.C(string);
        Map<String, Object> map = this.A();
        return map != null && map.containsKey(string);
    }

    protected Object getResource(String string) {
        this.C(string);
        Map<String, Object> map = this.A();
        Object object = map != null ? map.get(string) : null;
        return object == H ? null : object;
    }

    protected void putResource(String string, Object object) {
        this.C(string);
        Map<String, Object> map = this.A();
        if (map != null) {
            map.put(string, object == null ? H : object);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getObject(String string, Class clazz) {
        void var2_11;
        ResourceMap resourceMap;
        this.C(string);
        if (clazz == null) {
            throw new IllegalArgumentException("null type");
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                Class<Boolean> clazz2 = Boolean.class;
            } else if (clazz == Character.TYPE) {
                Class<Character> clazz3 = Character.class;
            } else if (clazz == Byte.TYPE) {
                Class<Byte> clazz4 = Byte.class;
            } else if (clazz == Short.TYPE) {
                Class<Short> clazz5 = Short.class;
            } else if (clazz == Integer.TYPE) {
                Class<Integer> clazz6 = Integer.class;
            } else if (clazz == Long.TYPE) {
                Class<Long> clazz7 = Long.class;
            } else if (clazz == Float.TYPE) {
                Class<Float> clazz8 = Float.class;
            } else if (clazz == Double.TYPE) {
                Class<Double> clazz9 = Double.class;
            }
        }
        Object object = null;
        for (resourceMap = this; resourceMap != null; resourceMap = resourceMap.getParent()) {
            if (!resourceMap.containsResourceKey(string)) continue;
            object = resourceMap.getResource(string);
            break;
        }
        if (object instanceof String && ((String)object).contains("${")) {
            object = this.B((String)object);
            resourceMap.putResource(string, object);
        }
        if (object == null) return object;
        Class<?> clazz10 = object.getClass();
        if (var2_11.isAssignableFrom(clazz10)) return object;
        if (!(object instanceof String)) {
            String string2 = "named resource has wrong type";
            throw new LookupException(string2, string, (Class)var2_11);
        }
        ResourceConverter resourceConverter = ResourceConverter.forType((Class)var2_11);
        if (resourceConverter == null) {
            String string3 = "no StringConverter for required type";
            throw new LookupException(string3, string, (Class)var2_11);
        }
        String string4 = (String)object;
        try {
            object = resourceConverter.parseString(string4, resourceMap);
            resourceMap.putResource(string, object);
            return object;
        }
        catch (ResourceConverter.ResourceConverterException resourceConverterException) {
            String string5 = "string conversion failed";
            LookupException lookupException = new LookupException(string5, string, (Class)var2_11);
            lookupException.initCause(resourceConverterException);
            throw lookupException;
        }
    }

    private String B(String string) {
        if (string.trim().equals("${null}")) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf("${", n)) != -1) {
            if (n2 == 0 || n2 > 0 && string.charAt(n2 - 1) != '\\') {
                String string2;
                int n3 = string.indexOf("}", n2);
                if (n3 != -1 && n3 > n2 + 2) {
                    string2 = string.substring(n2 + 2, n3);
                    String string3 = this.getString(string2, new Object[0]);
                    stringBuffer.append(string.substring(n, n2));
                    if (string3 == null) {
                        String string4 = String.format("no value for \"%s\" in \"%s\"", string2, string);
                        throw new LookupException(string4, string2, String.class);
                    }
                    stringBuffer.append(string3);
                    n = n3 + 1;
                    continue;
                }
                string2 = String.format("no closing brace in \"%s\"", string);
                throw new LookupException(string2, "<not found>", String.class);
            }
            stringBuffer.append(string.substring(n, n2 - 1));
            stringBuffer.append("${");
            n = n2 + 2;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public String getString(String string, Object ... objectArray) {
        if (objectArray.length == 0) {
            return (String)this.getObject(string, String.class);
        }
        String string2 = (String)this.getObject(string, String.class);
        return string2 == null ? null : String.format(string2, objectArray);
    }

    public final Boolean getBoolean(String string) {
        return (Boolean)this.getObject(string, Boolean.class);
    }

    public final Integer getInteger(String string) {
        return (Integer)this.getObject(string, Integer.class);
    }

    public final Long getLong(String string) {
        return (Long)this.getObject(string, Long.class);
    }

    public final Short getShort(String string) {
        return (Short)this.getObject(string, Short.class);
    }

    public final Byte getByte(String string) {
        return (Byte)this.getObject(string, Byte.class);
    }

    public final Float getFloat(String string) {
        return (Float)this.getObject(string, Float.class);
    }

    public final Double getDouble(String string) {
        return (Double)this.getObject(string, Double.class);
    }

    public final Icon getIcon(String string) {
        return (Icon)this.getObject(string, Icon.class);
    }

    public final ImageIcon getImageIcon(String string) {
        return (ImageIcon)this.getObject(string, ImageIcon.class);
    }

    public final Font getFont(String string) {
        return (Font)this.getObject(string, Font.class);
    }

    public final Color getColor(String string) {
        return (Color)this.getObject(string, Color.class);
    }

    public final KeyStroke getKeyStroke(String string) {
        return (KeyStroke)this.getObject(string, KeyStroke.class);
    }

    public Integer getKeyCode(String string) {
        KeyStroke keyStroke = this.getKeyStroke(string);
        return keyStroke != null ? new Integer(keyStroke.getKeyCode()) : null;
    }

    private void A(Component component, PropertyDescriptor propertyDescriptor, String string) {
        Method method = propertyDescriptor.getWriteMethod();
        Class<?> clazz = propertyDescriptor.getPropertyType();
        if (method != null && clazz != null && this.containsKey(string)) {
            Object object = this.getObject(string, clazz);
            String string2 = propertyDescriptor.getName();
            try {
                if ("text".equals(string2) && component instanceof AbstractButton) {
                    org.jdesktop.application.A.A(component, (String)object);
                }
                if ("text".equals(string2) && component instanceof JLabel) {
                    org.jdesktop.application.A.A(component, (String)object);
                }
                method.invoke((Object)component, object);
            }
            catch (Exception exception) {
                String string3 = propertyDescriptor.getName();
                String string4 = "property setter failed";
                PropertyInjectionException propertyInjectionException = new PropertyInjectionException(string4, string, component, string3);
                propertyInjectionException.initCause(exception);
                throw propertyInjectionException;
            }
        } else {
            if (clazz != null) {
                String string5 = propertyDescriptor.getName();
                String string6 = "no value specified for resource";
                throw new PropertyInjectionException(string6, string, component, string5);
            }
            if (method == null) {
                String string7 = propertyDescriptor.getName();
                String string8 = "can't set read-only property";
                throw new PropertyInjectionException(string8, string, component, string7);
            }
        }
    }

    private void A(Component component) {
        String string = component.getName();
        if (string != null) {
            boolean bl = false;
            for (String propertyDescriptorArray2 : this.keySet()) {
                int string2 = propertyDescriptorArray2.lastIndexOf(".");
                if (string2 == -1 || !string.equals(propertyDescriptorArray2.substring(0, string2))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
            Object object = null;
            try {
                object = Introspector.getBeanInfo(component.getClass());
            }
            catch (IntrospectionException introspectionException) {
                String string2 = "introspection failed";
                PropertyInjectionException string3 = new PropertyInjectionException(string2, null, component, null);
                string3.initCause(introspectionException);
                throw string3;
            }
            PropertyDescriptor[] propertyDescriptorArray = object.getPropertyDescriptors();
            if (propertyDescriptorArray != null && propertyDescriptorArray.length > 0) {
                for (String string3 : this.keySet()) {
                    String string4;
                    int n = string3.lastIndexOf(".");
                    String string5 = n == -1 ? null : string3.substring(0, n);
                    if (!string.equals(string5)) continue;
                    if (n + 1 == string3.length()) {
                        string4 = "component resource lacks property name suffix";
                        I.warning(string4);
                        break;
                    }
                    string4 = string3.substring(n + 1);
                    boolean bl2 = false;
                    for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                        if (!propertyDescriptor.getName().equals(string4)) continue;
                        this.A(component, propertyDescriptor, string3);
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    String string6 = String.format("[resource %s] component named %s doesn't have a property named %s", string3, string, string4);
                    I.warning(string6);
                }
            }
        }
    }

    public void injectComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null target");
        }
        this.A(component);
    }

    public void injectComponents(Component component) {
        block3: {
            block2: {
                this.injectComponent(component);
                if (!(component instanceof JMenu)) break block2;
                JMenu jMenu = (JMenu)component;
                for (Component component2 : jMenu.getMenuComponents()) {
                    this.injectComponents(component2);
                }
                break block3;
            }
            if (!(component instanceof Container)) break block3;
            Container container = (Container)component;
            for (Component component3 : container.getComponents()) {
                this.injectComponents(component3);
            }
        }
    }

    private void A(Field field, Object object, String string) {
        Class<?> clazz = field.getType();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
            Pattern pattern = Pattern.compile(string + "\\[([\\d]+)\\]");
            ArrayList arrayList = new ArrayList();
            for (String string2 : this.keySet()) {
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.matches()) continue;
                Object object2 = this.getObject(string2, clazz);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                try {
                    int n = Integer.parseInt(matcher.group(1));
                    Array.set(field.get(object), n, object2);
                }
                catch (Exception exception) {
                    String string3 = "unable to set array element";
                    InjectFieldException injectFieldException = new InjectFieldException(string3, field, object, string);
                    injectFieldException.initCause(exception);
                    throw injectFieldException;
                }
            }
        } else {
            Object object3 = this.getObject(string, clazz);
            if (object3 != null) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                try {
                    field.set(object, object3);
                }
                catch (Exception exception) {
                    String string4 = "unable to set field's value";
                    InjectFieldException injectFieldException = new InjectFieldException(string4, field, object, string);
                    injectFieldException.initCause(exception);
                    throw injectFieldException;
                }
            }
        }
    }

    public void injectFields(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null target");
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            throw new IllegalArgumentException("array target");
        }
        String string = clazz.getSimpleName() + ".";
        for (Field field : clazz.getDeclaredFields()) {
            Resource resource = field.getAnnotation(Resource.class);
            if (resource == null) continue;
            String string2 = resource.key();
            String string3 = string2.length() > 0 ? string2 : string + field.getName();
            this.A(field, object, string3);
        }
    }

    private static String A(String string, ResourceMap resourceMap) {
        String string2 = string;
        string2 = string == null ? null : (string.startsWith("/") ? (string.length() > 1 ? string.substring(1) : null) : resourceMap.getResourcesDir() + string);
        return string2;
    }

    private static ImageIcon C(String string, ResourceMap resourceMap) throws ResourceConverter.ResourceConverterException {
        String string2 = ResourceMap.A(string, resourceMap);
        if (string2 == null) {
            String string3 = String.format("invalid image/icon path \"%s\"", string);
            throw new ResourceConverter.ResourceConverterException(string3, string);
        }
        URL uRL = resourceMap.getClassLoader().getResource(string2);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        String string4 = String.format("couldn't find Icon resource \"%s\"", string);
        throw new ResourceConverter.ResourceConverterException(string4, string);
    }

    private static List<Double> B(String string, int n, String string2) throws ResourceConverter.ResourceConverterException {
        String[] stringArray = string.split(",", n + 1);
        if (stringArray.length != n) {
            throw new ResourceConverter.ResourceConverterException(string2, string);
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        for (String string3 : stringArray) {
            try {
                arrayList.add(Double.valueOf(string3));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ResourceConverter.ResourceConverterException(string2, string, numberFormatException);
            }
        }
        return arrayList;
    }

    static {
        ResourceConverter[] resourceConverterArray;
        I = Logger.getLogger(ResourceMap.class.getName());
        H = new String("null resource");
        for (ResourceConverter resourceConverter : resourceConverterArray = new ResourceConverter[]{new _E(), new _I(), new _F(), new _A(), new _D(), new _H(), new _G(), new _B(), new _J(), new _C()}) {
            ResourceConverter.register(resourceConverter);
        }
    }

    private static class _E
    extends ResourceConverter {
        _E() {
            super(Color.class);
        }

        private void A(String string, String string2, Exception exception) throws ResourceConverter.ResourceConverterException {
            throw new ResourceConverter.ResourceConverterException(string, string2, exception);
        }

        private void A(String string, String string2) throws ResourceConverter.ResourceConverterException {
            this.A(string, string2, null);
        }

        public Object parseString(String string, ResourceMap resourceMap) throws ResourceConverter.ResourceConverterException {
            Color color = null;
            if (string.startsWith("#")) {
                switch (string.length()) {
                    case 7: {
                        color = Color.decode(string);
                        break;
                    }
                    case 9: {
                        int n = Integer.decode(string.substring(0, 3));
                        int n2 = Integer.decode("#" + string.substring(3));
                        color = new Color(n << 24 | n2, true);
                        break;
                    }
                    default: {
                        throw new ResourceConverter.ResourceConverterException("invalid #RRGGBB or #AARRGGBB color string", string);
                    }
                }
            } else {
                String[] stringArray = string.split(",");
                if (stringArray.length < 3 || stringArray.length > 4) {
                    throw new ResourceConverter.ResourceConverterException("invalid R, G, B[, A] color string", string);
                }
                try {
                    if (stringArray.length == 4) {
                        int n = Integer.parseInt(stringArray[0].trim());
                        int n3 = Integer.parseInt(stringArray[1].trim());
                        int n4 = Integer.parseInt(stringArray[2].trim());
                        int n5 = Integer.parseInt(stringArray[3].trim());
                        color = new Color(n, n3, n4, n5);
                    } else {
                        int n = Integer.parseInt(stringArray[0].trim());
                        int n6 = Integer.parseInt(stringArray[1].trim());
                        int n7 = Integer.parseInt(stringArray[2].trim());
                        color = new Color(n, n6, n7);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ResourceConverter.ResourceConverterException("invalid R, G, B[, A] color string", string, numberFormatException);
                }
            }
            return color;
        }
    }

    private static class _H
    extends ResourceConverter {
        _H() {
            super(Dimension.class);
        }

        public Object parseString(String string, ResourceMap resourceMap) throws ResourceConverter.ResourceConverterException {
            List list = ResourceMap.B(string, 2, "invalid x,y Dimension string");
            Dimension dimension = new Dimension();
            dimension.setSize((Double)list.get(0), (Double)list.get(1));
            return dimension;
        }
    }

    private static class _C
    extends ResourceConverter {
        _C() {
            super(EmptyBorder.class);
        }

        public Object parseString(String string, ResourceMap resourceMap) throws ResourceConverter.ResourceConverterException {
            List list = ResourceMap.B(string, 4, "invalid top,left,bottom,right EmptyBorder string");
            return new EmptyBorder(((Double)list.get(0)).intValue(), ((Double)list.get(1)).intValue(), ((Double)list.get(2)).intValue(), ((Double)list.get(3)).intValue());
        }
    }

    private static class _A
    extends ResourceConverter {
        _A() {
            super(Font.class);
        }

        public Object parseString(String string, ResourceMap resourceMap) throws ResourceConverter.ResourceConverterException {
            return Font.decode(string);
        }
    }

    private static class _I
    extends ResourceConverter {
        _I() {
            super(Icon.class);
        }

        public Object parseString(String string, ResourceMap resourceMap) throws ResourceConverter.ResourceConverterException {
            return ResourceMap.C(string, resourceMap);
        }

        public boolean supportsType(Class clazz) {
            return clazz.equals(Icon.class) || clazz.equals(ImageIcon.class);
        }
    }

    private static class _F
    extends ResourceConverter {
        _F() {
            super(Image.class);
        }

        public Object parseString(String string, ResourceMap resourceMap) throws ResourceConverter.ResourceConverterException {
            return ResourceMap.C(string, resourceMap).getImage();
        }
    }

    public static class InjectFieldException
    extends RuntimeException {
        private final Field C;
        private final Object B;
        private final String A;

        public InjectFieldException(String string, Field field, Object object, String string2) {
            super(String.format("%s: resource %s, field %s, target %s", string, string2, field, object));
            this.C = field;
            this.B = object;
            this.A = string2;
        }

        public Field getField() {
            return this.C;
        }

        public Object getTarget() {
            return this.B;
        }

        public String getKey() {
            return this.A;
        }
    }

    private static class _J
    extends ResourceConverter {
        _J() {
            super(Insets.class);
        }

        public Object parseString(String string, ResourceMap resourceMap) throws ResourceConverter.ResourceConverterException {
            List list = ResourceMap.B(string, 4, "invalid top,left,bottom,right Insets string");
            return new Insets(((Double)list.get(0)).intValue(), ((Double)list.get(1)).intValue(), ((Double)list.get(2)).intValue(), ((Double)list.get(3)).intValue());
        }
    }

    private static class _D
    extends ResourceConverter {
        _D() {
            super(KeyStroke.class);
        }

        public Object parseString(String string, ResourceMap resourceMap) {
            if (string.contains("shortcut")) {
                int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                string = string.replaceAll("shortcut", n == 4 ? "meta" : "control");
            }
            return KeyStroke.getKeyStroke(string);
        }
    }

    public static class LookupException
    extends RuntimeException {
        private final Class B;
        private final String A;

        public LookupException(String string, String string2, Class clazz) {
            super(String.format("%s: resource %s, type %s", string, string2, clazz));
            this.A = string2;
            this.B = clazz;
        }

        public Class getType() {
            return this.B;
        }

        public String getKey() {
            return this.A;
        }
    }

    private static class _G
    extends ResourceConverter {
        _G() {
            super(Point.class);
        }

        public Object parseString(String string, ResourceMap resourceMap) throws ResourceConverter.ResourceConverterException {
            List list = ResourceMap.B(string, 2, "invalid x,y Point string");
            Point point = new Point();
            point.setLocation((Double)list.get(0), (Double)list.get(1));
            return point;
        }
    }

    public static class PropertyInjectionException
    extends RuntimeException {
        private final String C;
        private final Component B;
        private final String A;

        public PropertyInjectionException(String string, String string2, Component component, String string3) {
            super(String.format("%s: resource %s, property %s, component %s", string, string2, string3, component));
            this.C = string2;
            this.B = component;
            this.A = string3;
        }

        public String getKey() {
            return this.C;
        }

        public Component getComponent() {
            return this.B;
        }

        public String getPropertyName() {
            return this.A;
        }
    }

    private static class _B
    extends ResourceConverter {
        _B() {
            super(Rectangle.class);
        }

        public Object parseString(String string, ResourceMap resourceMap) throws ResourceConverter.ResourceConverterException {
            List list = ResourceMap.B(string, 4, "invalid x,y,width,height Rectangle string");
            Rectangle rectangle = new Rectangle();
            rectangle.setFrame((Double)list.get(0), (Double)list.get(1), (Double)list.get(2), (Double)list.get(3));
            return rectangle;
        }
    }
}

