/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskService
extends AbstractBean {
    private final String h;
    private final ExecutorService j;
    private final List<Task> k;
    private final PropertyChangeListener i;

    public TaskService(String string, ExecutorService executorService) {
        if (string == null) {
            throw new IllegalArgumentException("null name");
        }
        if (executorService == null) {
            throw new IllegalArgumentException("null executorService");
        }
        this.h = string;
        this.j = executorService;
        this.k = new ArrayList<Task>();
        this.i = new _A();
    }

    public TaskService(String string) {
        this(string, new ThreadPoolExecutor(3, 10, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public final String getName() {
        return this.h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Task> K() {
        List<Task> list = this.k;
        synchronized (list) {
            if (this.k.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<Task>(this.k);
        }
    }

    private void A(Task task) {
        final Task.InputBlocker inputBlocker = task.getInputBlocker();
        if (inputBlocker == null) {
            return;
        }
        if (inputBlocker.getScope() != Task.BlockingScope.NONE) {
            if (SwingUtilities.isEventDispatchThread()) {
                inputBlocker.block();
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        inputBlocker.block();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Task task) {
        List<Task> list;
        List<Task> list2;
        if (task == null) {
            throw new IllegalArgumentException("null task");
        }
        if (!task.isPending() || task.getTaskService() != null) {
            throw new IllegalArgumentException("task has already been executed");
        }
        task.A(this);
        List<Task> list3 = this.k;
        synchronized (list3) {
            list2 = this.K();
            this.k.add(task);
            list = this.K();
            task.addPropertyChangeListener(this.i);
        }
        this.firePropertyChange("tasks", list2, list);
        this.A(task);
        this.j.execute(task);
    }

    public List<Task> getTasks() {
        return this.K();
    }

    public final void shutdown() {
        this.j.shutdown();
    }

    public final List<Runnable> shutdownNow() {
        return this.j.shutdownNow();
    }

    public final boolean isShutdown() {
        return this.j.isShutdown();
    }

    public final boolean isTerminated() {
        return this.j.isTerminated();
    }

    public final boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.j.awaitTermination(l, timeUnit);
    }

    private class _A
    implements PropertyChangeListener {
        private _A() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Task task;
            String string = propertyChangeEvent.getPropertyName();
            if ("done".equals(string) && (task = (Task)propertyChangeEvent.getSource()).isDone()) {
                List list;
                List list2;
                Object object = TaskService.this.k;
                synchronized (object) {
                    list2 = TaskService.this.K();
                    TaskService.this.k.remove(task);
                    task.removePropertyChangeListener(TaskService.this.i);
                    list = TaskService.this.K();
                }
                TaskService.this.firePropertyChange("tasks", list2, list);
                object = task.getInputBlocker();
                if (object != null) {
                    ((Task.InputBlocker)object).unblock();
                }
            }
        }
    }
}

