/*
 * Decompiled with CFR 0.152.
 */
package secureSWF.gui.helpers;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import secureSWF.G.B;
import secureSWF.G.C;
import secureSWF.G.E;
import secureSWF.G.F;
import secureSWF.settings.AS3FileInfo;
import secureSWF.settings.AirFileInfo;
import secureSWF.settings.Identifier;
import secureSWF.settings.SwcFileInfo;
import secureSWF.settings.SwfFileInfo;
import secureSWF.settings.SwfMovieClip;
import secureSWF.settings.SwfProcessingSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionHelper {
    public static void processSettings(SwfProcessingSettings swfProcessingSettings) {
        int n;
        Identifier[] identifierArray;
        int n2;
        int n3 = swfProcessingSettings.getRenamingLevel();
        SwfFileInfo[] swfFileInfoArray = swfProcessingSettings.getSwfFiles();
        AirFileInfo[] airFileInfoArray = swfProcessingSettings.getAirFiles();
        SwcFileInfo[] swcFileInfoArray = swfProcessingSettings.getSwcFiles();
        for (n2 = 0; n2 < swfFileInfoArray.length && swfFileInfoArray[n2].isAs3(); ++n2) {
            identifierArray = swfFileInfoArray[n2].getAs3Packages();
            for (n = 0; n < identifierArray.length; ++n) {
                ExecutionHelper.A(identifierArray[n], n3);
            }
        }
        for (n2 = 0; n2 < swcFileInfoArray.length && swcFileInfoArray[n2].isAs3(); ++n2) {
            if (swcFileInfoArray[n2].getLibrary() == null) continue;
            identifierArray = swcFileInfoArray[n2].getLibrary().getAs3Packages();
            for (n = 0; n < identifierArray.length; ++n) {
                ExecutionHelper.A(identifierArray[n], n3);
            }
        }
        for (n2 = 0; n2 < airFileInfoArray.length && airFileInfoArray[n2].isAs3(); ++n2) {
            identifierArray = airFileInfoArray[n2].getAs3Packages();
            for (n = 0; n < identifierArray.length; ++n) {
                ExecutionHelper.A(identifierArray[n2], n3);
            }
        }
    }

    public static Map<File, File> getFilesMap(SwfProcessingSettings swfProcessingSettings) {
        if (swfProcessingSettings.getSwfFiles().length + swfProcessingSettings.getSwcFiles().length + swfProcessingSettings.getAirFiles().length != swfProcessingSettings.getFilesMap().size()) {
            File file;
            Comparable<AS3FileInfo> comparable;
            int n;
            for (n = 0; n < swfProcessingSettings.getSwfFiles().length; ++n) {
                comparable = swfProcessingSettings.getSwfFiles()[n];
                if (swfProcessingSettings.getFilesMap().containsKey(new File(((SwfFileInfo)comparable).getFileFullName()))) continue;
                file = new File(((SwfFileInfo)comparable).getFileFullName());
                swfProcessingSettings.getFilesMap().put(file, new File(file.getParent(), "secure_" + file.getName()));
            }
            for (n = 0; n < swfProcessingSettings.getSwcFiles().length; ++n) {
                comparable = swfProcessingSettings.getSwcFiles()[n];
                if (swfProcessingSettings.getFilesMap().containsKey(new File(((SwcFileInfo)comparable).getFileFullName()))) continue;
                file = new File(((SwcFileInfo)comparable).getFileFullName());
                swfProcessingSettings.getFilesMap().put(file, new File(file.getParent(), "secure_" + file.getName()));
            }
            for (n = 0; n < swfProcessingSettings.getAirFiles().length; ++n) {
                comparable = swfProcessingSettings.getAirFiles()[n];
                if (swfProcessingSettings.getFilesMap().containsKey(new File(((AirFileInfo)comparable).getFileFullName()))) continue;
                file = new File(((AirFileInfo)comparable).getFileFullName());
                swfProcessingSettings.getFilesMap().put(file, new File(file.getParent(), "secure_" + file.getName()));
            }
        }
        return swfProcessingSettings.getFilesMap();
    }

    private static void A(Identifier identifier, int n) {
        Identifier[] identifierArray;
        if (!identifier.getChanged().booleanValue()) {
            identifier.setRenameSelectedValue(identifier.getRenamingLevel() <= n);
        }
        if ((identifierArray = identifier.getMembers()) != null && identifierArray.length > 0) {
            for (int i = 0; i < identifierArray.length; ++i) {
                ExecutionHelper.A(identifierArray[i], n);
            }
        }
    }

    public static String getNewFilePath(Map<File, File> map, String string, OUTPUT_OPTION oUTPUT_OPTION, String string2, boolean bl) throws E {
        String string3;
        File file = new File(string);
        if (oUTPUT_OPTION == OUTPUT_OPTION.MAPPED) {
            for (File file2 : map.keySet()) {
                if (!file2.getPath().equals(string)) continue;
                return map.get(file2).getAbsolutePath();
            }
            throw new E("No output path was selected for\n" + string, false);
        }
        if (oUTPUT_OPTION == OUTPUT_OPTION.SAVE_TO_FOLDER) {
            if (string2.length() != 0) {
                return new File(string2, file.getName()).getAbsolutePath() + (string.toUpperCase().endsWith(".AIR") && bl ? "i" : "");
            }
            return string + (string.toUpperCase().endsWith(".AIR") && bl ? "i" : "");
        }
        if (oUTPUT_OPTION == OUTPUT_OPTION.POSTFIX) {
            String string4;
            if (string2.length() == 0) {
                string2 = "_secure";
            }
            if ((string4 = file.getName()).contains(".")) {
                string4 = string4.substring(0, string4.lastIndexOf(46)) + string2;
            }
            if (!secureSWF.E.E.A(string4 = string4 + string.substring(string.lastIndexOf(46)))) {
                throw new E("Invalid file name: " + string4, false);
            }
            return new File(file.getParentFile(), string4).getAbsolutePath() + (string.toUpperCase().endsWith(".AIR") && bl ? "i" : "");
        }
        if (string2.length() == 0) {
            string2 = "secure_";
        }
        if (!secureSWF.E.E.A(string3 = string2 + file.getName())) {
            throw new E("Invalid file name: " + string3, false);
        }
        return new File(file.getParentFile(), string3).getAbsolutePath() + (string.toUpperCase().endsWith(".AIR") && bl ? "i" : "");
    }

    public static SwfProcessingSettings deselectWarnings(C c2, SwfProcessingSettings swfProcessingSettings) throws F, E, IOException, NoSuchAlgorithmException, B, Exception {
        String[] stringArray = c2.A();
        if (stringArray.length != 0) {
            int n;
            swfProcessingSettings = c2.D(swfProcessingSettings);
            SwfFileInfo[] swfFileInfoArray = new SwfFileInfo[swfProcessingSettings.getSwfFiles().length + swfProcessingSettings.getSwcFiles().length];
            System.arraycopy(swfProcessingSettings.getSwfFiles(), 0, swfFileInfoArray, 0, swfProcessingSettings.getSwfFiles().length);
            for (n = swfProcessingSettings.getSwfFiles().length; n < swfFileInfoArray.length; ++n) {
                swfFileInfoArray[n] = swfProcessingSettings.getSwcFiles()[swfFileInfoArray.length - n - 1].getLibrary();
            }
            for (n = 0; n < swfFileInfoArray.length; ++n) {
                ExecutionHelper.A(swfFileInfoArray, n, stringArray);
            }
            n = ExecutionHelper.getMinVersion(swfProcessingSettings) < 7 ? 1 : 0;
            AirFileInfo[] airFileInfoArray = swfProcessingSettings.getAirFiles();
            for (int i = 0; i < airFileInfoArray.length; ++i) {
                Identifier[] identifierArray = airFileInfoArray[i].getAs3Packages();
                for (int j = 0; j < identifierArray.length; ++j) {
                    ExecutionHelper.A(identifierArray[j], stringArray, n != 0);
                }
                SwfMovieClip[] swfMovieClipArray = airFileInfoArray[i].getMovieClips();
                ExecutionHelper.A(swfMovieClipArray, identifierArray, stringArray, n != 0);
            }
        }
        return swfProcessingSettings;
    }

    private static void A(Identifier identifier, String[] stringArray, boolean bl) {
        Identifier[] identifierArray;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!(bl ? identifier.getName().equalsIgnoreCase(stringArray[i]) : identifier.getName().equals(stringArray[i]))) continue;
            identifier.setRenameSelectedValue(false);
            identifier.setChanged(true);
            break;
        }
        if ((identifierArray = identifier.getMembers()) != null && identifierArray.length > 0) {
            for (int i = 0; i < identifierArray.length; ++i) {
                ExecutionHelper.A(identifierArray[i], stringArray, bl);
            }
        }
    }

    public static int getMinVersion(SwfProcessingSettings swfProcessingSettings) {
        int n;
        int n2 = Integer.MAX_VALUE;
        for (n = 0; n < swfProcessingSettings.getSwfFiles().length; ++n) {
            n2 = Math.min(swfProcessingSettings.getSwfFiles()[n].getVersion(), n2);
        }
        for (n = 0; n < swfProcessingSettings.getSwcFiles().length; ++n) {
            n2 = Math.min(swfProcessingSettings.getSwcFiles()[n].getVersion(), n2);
        }
        for (n = 0; n < swfProcessingSettings.getAirFiles().length; ++n) {
            n2 = Math.min(swfProcessingSettings.getAirFiles()[n].getVersion(), n2);
        }
        return n2;
    }

    private static void A(SwfFileInfo[] swfFileInfoArray, int n, String[] stringArray) {
        int n2;
        Identifier[] identifierArray = swfFileInfoArray[n].getAs2Classes();
        boolean bl = swfFileInfoArray[n].getVersion() < 7;
        for (n2 = 0; n2 < identifierArray.length; ++n2) {
            ExecutionHelper.A(identifierArray[n2], stringArray, bl);
        }
        identifierArray = swfFileInfoArray[n].getAs3Packages();
        for (n2 = 0; n2 < identifierArray.length; ++n2) {
            ExecutionHelper.A(identifierArray[n2], stringArray, bl);
        }
        identifierArray = swfFileInfoArray[n].getClassMembers();
        for (n2 = 0; n2 < identifierArray.length; ++n2) {
            ExecutionHelper.A(identifierArray[n2], stringArray, bl);
        }
        identifierArray = swfFileInfoArray[n].getGlobalVariables();
        for (n2 = 0; n2 < identifierArray.length; ++n2) {
            ExecutionHelper.A(identifierArray[n2], stringArray, bl);
        }
        SwfMovieClip[] swfMovieClipArray = swfFileInfoArray[n].getMovieClips();
        ExecutionHelper.A(swfMovieClipArray, identifierArray, stringArray, bl);
    }

    private static void A(SwfMovieClip[] swfMovieClipArray, Identifier[] identifierArray, String[] stringArray, boolean bl) {
        for (int i = 0; i < swfMovieClipArray.length; ++i) {
            int n;
            identifierArray = swfMovieClipArray[i].getInstanceNames();
            for (n = 0; n < identifierArray.length; ++n) {
                ExecutionHelper.A(identifierArray[n], stringArray, bl);
            }
            identifierArray = swfMovieClipArray[i].getLabels();
            for (n = 0; n < identifierArray.length; ++n) {
                ExecutionHelper.A(identifierArray[n], stringArray, bl);
            }
            identifierArray = swfMovieClipArray[i].getLocalIdentifiers();
            for (n = 0; n < identifierArray.length; ++n) {
                ExecutionHelper.A(identifierArray[n], stringArray, bl);
            }
        }
    }

    private ExecutionHelper() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OUTPUT_OPTION {
        POSTFIX,
        PREFIX,
        SAVE_TO_FOLDER,
        MAPPED;

    }
}

